/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/*
 * sph_phot.h
 *
 *  Created on: Jul 16, 2016
 *      Author: pavlov
 */

#ifndef SPH_PHOT_H_
#define SPH_PHOT_H_


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include "sph_strehl.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/
#define SPH_PHOT_FILTER_IRD_KEY  SPH_STREHL_FILTER_IRD1
#define SPH_PHOT_FILTER_1_ZIMPOL_KEY SPH_STREHL_FILTER_ZPL1
#define SPH_PHOT_FILTER_2_ZIMPOL_KEY SPH_STREHL_FILTER_ZPL2

#define SPH_PHOT_FILTER_ZPL_CAM1_KEY  "ZPL FILTER CAM1"
#define SPH_PHOT_FILTER_ZPL_CAM2_KEY  "ZPL FILTER CAM2"

#define SPH_PHOT_FILTER_ZPL_VAL1  "ZPL FILTER CAM1"
#define SPH_PHOT_FILTER_ZPL_VAL2  "ZPL FILTER CAM2"

#define SPH_COMMON_TARGET_NAME_KEY   "ESO OBS TARG NAME"
#define SPH_PHOTO_COROIN_KEY      "ESO COROIN"  //not real, not used

#define SPH_PHOT_STDSTAR_TABLE_TARGET_KEY   "Target"

#define SPH_STREHL_QC_STREHL_1_FLUX      "ESO QC STREHL1 FLUX"
#define SPH_STREHL_QC_STREHL_2_FLUX      "ESO QC STREHL2 FLUX"

/*-----------------------------------------------------------------------------
                                   Function declarations
 -----------------------------------------------------------------------------*/



cpl_error_code sph_phot_irdis(cpl_propertylist* phot_list_left,
							  cpl_propertylist* phot_list_right,
							  const double strehl_flux_left,
							  const double strehl_flux_right,
                              const cpl_propertylist* pl_frame,
                              const cpl_frame* inframe,
                              const cpl_frame* starframe,
                              const cpl_frame* filterframe);

cpl_propertylist* sph_phot_zimpol(const double strehl_flux_cam,
								  const cpl_boolean is_arm1,
                                  const cpl_frame* inframe,
                                  const cpl_frame* starframe,
								  const cpl_frame* filterframe);

cpl_error_code sph_phot_read_filter_and_scale(
									const cpl_propertylist * self,
                                    sph_arm                  arm,
                                    double                 * ppscale,
                                    const char            ** pkey,
                                    const char            ** pfilter);

#endif /* SPH_PHOT_H_ */
