/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_SPECTRUM_H_
#define SPH_SPECTRUM_H_
#include <cpl.h>
#include "sph_dataset.h"

typedef struct _sph_spectrum_
{
    int                    specid; // spectrum id
    int					   lensid; // lenslet id;
    cpl_vector*            spec;
    cpl_vector*            wavelengths;
    cpl_vector*            rms;
    cpl_vector*            ncomb;
    cpl_vector*			   bads;

} sph_spectrum;


sph_spectrum*
sph_spectrum_new( int npoints, double minlambda, double maxlambda );

sph_spectrum*
sph_spectrum_load( const char* czFilename );

void sph_spectrum_delete( sph_spectrum* self);
sph_dataset*
sph_spectrum_convert_to_dataset( sph_spectrum* spec );

cpl_vector*
sph_spectrum_fit_wavs( sph_spectrum* self,
        cpl_vector* calib_lines,
        int degree,
        int tol, cpl_vector** pdiffs,
        cpl_vector** pderiv,
        cpl_vector* coeffs);
double sph_spectrum_get_resolving_power( sph_spectrum* self );

int sph_spectrum_save( sph_spectrum* self, const char* filename );
int sph_spectrum_dump( sph_spectrum* self );
double sph_spectrum_get_value( sph_spectrum* self, double value );
sph_spectrum*
sph_spectrum_new_interpolate( sph_spectrum* self, cpl_vector* wavs );

int sph_spectrum_fit_gauss( sph_spectrum* self, double* x0,
                            double* sigma, double* chi );
#endif /*SPH_SPECTRUM_H_*/
