/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#ifndef SPH_TIME_H_
#define SPH_TIME_H_

#include <sys/time.h>

#define BENCH_NTIMERS 2

typedef struct timeval mytime;
typedef struct tm tmstruct;
int sph_time_get_time_seed(void);

int sph_time_start_timer(int n);

double sph_time_stop_timer(int n);

cpl_error_code
sph_time_iso8601_from_mjd(int * pyear, int * pmonth,
                                           int * pday, int * phour,
                                           int * pminute, double * psecond,
                                           double mjd);
cpl_error_code
sph_time_mjd_from_string(double * pmjd, const char * iso8601);

cpl_vector*
sph_time_extract_times_from_frame(
        const cpl_frame* inframe);

cpl_vector*
sph_time_extract_times_zpl( const cpl_frame* inframe );

sph_error_code
sph_time_get_time_ut( const cpl_frame* aframe, char* time_ut );

sph_error_code
sph_time_get_times( const cpl_frame* aframe,
        double* mjd_start, double* mjd_stop );

cpl_error_code
sph_time_iso8601_from_string(int * pyear, int * pmonth,
                                              int * pday, int * phour,
                                              int * pminute, double * psecond,
                                              const char * iso8601);


cpl_error_code sph_radec_rad_to_iso8601string(        double radec,        char * iso8601,        int    is_ra );

cpl_error_code sph_radec_deg_to_iso8601string(        double radec,        char * iso8601,        int    is_ra );

cpl_error_code
sph_time_mjd_to_iso8601string(
        double mjd,
        char * iso8601);

cpl_error_code
sph_time_mjd_from_iso8601(double * pmjd, int year, int month,
                                           int day, int hour, int minute,
                                           double second);

#endif /* SPH_TIME_H_ */
