/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_TRIPLE_IMAGE_H_
#define SPH_TRIPLE_IMAGE_H_
#include "sph_master_frame.h"
#include "sph_error.h"

typedef struct _sph_triple_image_
{
	sph_master_frame* 		iframe;
	sph_master_frame*		qframe;
	sph_master_frame*		uframe;
	cpl_propertylist*		properties;
	cpl_propertylist*		qclist;
} sph_triple_image;

/*-----------------------------------------------------------------------------
 Function prototypes
 -----------------------------------------------------------------------------*/

sph_triple_image* sph_triple_image_new_empty( void )   CPL_ATTR_ALLOC;
sph_triple_image* sph_triple_image_new( int nx, int ny )   CPL_ATTR_ALLOC;
sph_triple_image* sph_triple_image_new_from_master_frames( sph_master_frame* mf_i,
		sph_master_frame* mf_q, sph_master_frame* mf_u )   CPL_ATTR_ALLOC;

sph_master_frame* sph_triple_image_get_copy_i_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL CPL_ATTR_ALLOC;
sph_master_frame* sph_triple_image_get_copy_q_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL CPL_ATTR_ALLOC;
sph_master_frame* sph_triple_image_get_copy_u_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL CPL_ATTR_ALLOC;

sph_master_frame* sph_triple_image_get_iframe_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL;
sph_master_frame* sph_triple_image_get_x_iq_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL;
sph_master_frame* sph_triple_image_get_xt_qq_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL;

sph_master_frame* sph_triple_image_get_qframe_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL;
sph_master_frame* sph_triple_image_get_x_qq_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL;
sph_master_frame* sph_triple_image_get_xt_uq_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL;

sph_master_frame* sph_triple_image_get_uframe_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL;
sph_master_frame* sph_triple_image_get_x_uq_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL;
sph_master_frame* sph_triple_image_get_xt_vq_master_frame( sph_triple_image* self )
    CPL_ATTR_NONNULL;

sph_error_code	  sph_triple_image_add_triple_image( sph_triple_image* self, sph_triple_image* trimage)
    CPL_ATTR_NONNULL;
sph_error_code	  sph_triple_image_subtract_triple_image( sph_triple_image* self, sph_triple_image* trimage)
    CPL_ATTR_NONNULL;
sph_error_code 	  sph_triple_image_divide_double( sph_triple_image* self, double value)
    CPL_ATTR_NONNULL;
cpl_error_code 	  sph_triple_image_quality_check( sph_triple_image* self );

sph_triple_image* sph_triple_image_duplicate ( const sph_triple_image* self)   CPL_ATTR_ALLOC;

sph_triple_image* sph_triple_image_load( const char* czFilename, int plane )   CPL_ATTR_ALLOC;
sph_error_code sph_triple_image_save( sph_triple_image* self, const char* czFilename, cpl_propertylist* pli );
sph_error_code sph_triple_image_save_dfs(
		sph_triple_image* self,
		const char* outfilename,
		cpl_frameset* allframes,
		cpl_frame* template_frame,
		cpl_parameterlist* params,
		const char* tag,
		const char* recipe,
		const char* pipename,
		cpl_propertylist* plist);

void sph_triple_image_delete(sph_triple_image*);

#endif /* SPH_TRIPLE_IMAGE_H_ */
