/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_TEST_H_
#define SPH_TEST_H_
#include "sph_ifs_lenslet_model.h"
#include "sph_pixel_description_table.h"
#include "sph_dictionary.h"
#include "sph_filemanager.h"
#include "sph_utils.h"
enum _sph_test_fits_compare_ {
    SPH_TEST_PURE = 0,
    SPH_TEST_SUBTRACT_MEDIAN = 1,
    SPH_TEST_SUBTRACT_MEAN = 2,
    SPH_TEST_DIVIDE_MEAN = 3
};

typedef struct _sph_test_fits_stats_ {
    double rms;
    double mean;
    double median;
    double max;
    double min;
    int nbadpix;
} sph_test_fits_stats;

const char*
frame_group_to_string(cpl_frame_group group);

int
sph_test_create_dit_list(void);

cpl_error_code
sph_test_retag_frames_by_group(cpl_frameset* inoutframes, cpl_frame_group group,
        const char* newtag);

int
sph_test_create_results_file(const char* czFilename);

cpl_vector*
sph_test_cpl_vector_linear(int np, double min, double max);

cpl_vector*
sph_test_cpl_vector_gauss(int np, double min, double max, double mean,
        double sigma, double peak);

cpl_error_code
sph_test_create_ifs_master_dark_frame(cpl_frameset* frames, int ndits);

cpl_error_code
sph_test_create_ifs_raw_dark_frameset(cpl_frameset* frames, int nframes);

cpl_error_code
sph_test_create_ifs_raw_dark_frameset_big(cpl_frameset* frames, int nframes);

cpl_error_code
sph_test_create_ifs_raw_dff_frameset_broad_band(cpl_frameset* frames,
        int nframes, int lampOnId);

sph_pixel_description_table*
sph_test_create_ifs_master_pdt_frame(cpl_frameset* frames);

cpl_parameterlist*
sph_test_create_paramlist_ifs_spectra_positions(void);

cpl_parameterlist*
sph_test_create_paramlist_ifs_master_dark(void);

cpl_error_code
sph_test_create_ird_master_dark_frame(cpl_frameset* frames, int ndits);

cpl_error_code
sph_test_create_ird_raw_dark_frameset(cpl_frameset* frames, int nframes);

cpl_error_code
sph_test_create_ird_raw_iff_frameset_ci(cpl_frameset* frames, int nframes);

cpl_parameterlist*
sph_test_create_paramlist_ird_master_dark(void);

cpl_error_code
sph_test_create_zpl_raw_dark_frameset(cpl_frameset* frames, int nframes);

cpl_error_code
sph_test_create_zpl_raw_dark_frameset_et(cpl_frameset* frames, int nframes);

cpl_parameterlist*
sph_test_create_paramlist_zpl_master_dark(void);

int
sph_test_end(void);

sph_ifs_lenslet_model*
sph_test_create_small_lenslet_model(void);

cpl_error_code
sph_test_create_zpl_raw_iff_frameset(cpl_frameset* frames, int nframes);

cpl_error_code
sph_test_create_zpl_raw_pff_const_frameset(cpl_frameset* frames, int nframes);

cpl_error_code
sph_test_create_zpl_raw_meff_const_frameset(cpl_frameset* frames, int nframes);

void
sph_test_testfiles_add_file(const char* filename);

cpl_frame*
sph_test_frame_image(cpl_image* inimage, cpl_type_bpp bpp, const char* tag,
        cpl_frame_group group);

void
sph_test_cleanup_testfiles(void);

cpl_frame*
sph_test_cubify_image(cpl_image* inimage, const char* tag,
        cpl_frame_group group);

void
sph_test_frame_add_key_int(cpl_frame* frame, unsigned int ext, const char* name,
        int value);

void
sph_test_frame_add_key_string(cpl_frame* frame, unsigned int ext,
        const char* name, const char* value);

void
sph_test_frame_add_key_double(cpl_frame* frame, unsigned int ext,
        const char* name, double value);

const char*
sph_test_get_key_string(const char* filename, unsigned int ext,
        const char* name);

int
sph_test_get_key_int(const char* filename, unsigned int ext, const char* name);

double
sph_test_get_key_double(const char* filename, unsigned int ext,
        const char* name);

void
sph_test_frame_add_datestamp(cpl_frame* aframe);

sph_error_code sph_test_nop_code(void);
sph_error_code sph_end_test(void);

#define sph_test_init() sph_test_init_macro(__FILE__) 
int sph_test_init_macro(const char *)
    CPL_HAVE_ATTR_NONNULL;

const void * sph_add_suite(const char*, 
                           int (*)(void),
                           int (*)(void))
    CPL_HAVE_ATTR_NONNULL;

const void * sph_test_do(const void*, const char*,
                         void (*)(void))
    CPL_HAVE_ATTR_NONNULL;

void sph_test_nop_int(int);
void sph_test_nop_char(const char*)
    CPL_HAVE_ATTR_NONNULL;

void sph_test_later(const char *)
    CPL_HAVE_ATTR_NONNULL;

void sph_test_fail(const char *)
    CPL_HAVE_ATTR_NONNULL;

int sph_test_get_error(void);

void sph_test_noneq_abs(double, double, double);

void sph_test_frameset_delete(cpl_frameset*);

#endif /*SPH_TEST_H_*/
