/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#define _sph_ifs_test_fixtures_calib_products_C
#include <cpl.h>
#include "sph_error.h"
#include "sph_ifs_test_fixtures_calib_products.h"
#include "sph_ifs_test_fixtures_science_raw.h"
#include "sph_error.h"
#include "sph_test.h"
#include "sph_test_ngc_ir_simulator.h"
#include "sph_test_pupilimage_creator.h"
#include "sph_master_frame.h"
#include "sph_cube.h"
#include "sph_utils.h"
#include "sph_ifs_tags.h"
#include "sph_test_ifs_instrument_model.h"
#include "sph_ifs_science_dr.h"
#include "sph_common_keywords.h"
#include "sph_test_image_tools.h"
#include "sph_fits.h"
#include "sph_frame_validator.h"
#include "sph_time.h"
#include <math.h>
extern cpl_table*
sph_ifs_instrument_flat_create_ifu_tab(sph_ldt* ldt);
#undef _sph_ifs_test_fixtures_calib_products_C

/*----------------------------------------------------------------------------*/
/**
 * @defgroup A SPHERE API Module
 * @par Synopsis:
 * @code
 * typedef _module_ {
 * } module
 * @endcode
 * @par Desciption:
 *
 * This module provides functionality for apertures, extending the functionality
 * as it exists for cpl_apertures.
 * static
 * indent sph_ifs_test_fixtures_calib_products.c -o sph_ifs_test_fixtures_calib_products.cc -bap -bbb -bbo -bc -blf -bl -bfda -cdb -nbfde -di30 -l80 -lc80 -lps -lp -nut -npcs -psl -sai -saf -saw -sc -bc -pi8 -ip8 -ci8
 *
 */
/*----------------------------------------------------------------------------*/
/**@{*/

cpl_frame*
sph_ifs_test_fixtures_calib_products_master_dark(sph_test_ngc_ir_simulator* ngc) {
    cpl_image* bias = NULL;
    cpl_image* dark = NULL;
    cpl_frame* mframe = NULL;
    sph_master_frame* masterdark = NULL;
    cpl_image* bads = NULL;
    double exptime = 1.3;

    cpl_test_error(CPL_ERROR_NONE);
    exptime = ngc->exptime;
    bias = sph_test_ngc_ir_simulator_create_bias_image(ngc);
    dark = sph_test_ngc_ir_simulator_create_dark_image(ngc);
    bads = sph_test_ngc_ir_simulator_create_static_badpixel_image(ngc);
    mframe = sph_filemanager_create_temp_frame(
            "master_dark_for_ifs_science_dr_test.fits", SPH_IFS_TAG_DARK_CALIB,
            CPL_FRAME_GROUP_CALIB);
    cpl_image_multiply_scalar(dark, exptime);
    cpl_image_add(dark, bias);
    masterdark = sph_master_frame_new_from_cpl_image(dark);
    sph_master_frame_set_bads_from_image(masterdark, bads);
    sph_master_frame_save(masterdark, cpl_frame_get_filename(mframe), NULL);
    sph_master_frame_delete(masterdark);
    masterdark = NULL;
    cpl_image_delete(dark);
    cpl_image_delete(bias);
    cpl_image_delete(bads);
    cpl_test_error(CPL_ERROR_NONE);
    return mframe;
}

cpl_frame*
sph_ifs_test_fixtures_calib_products_wave_calib(
        sph_test_ifs_instrument_model* insmodel) {
    cpl_frame* mframe = NULL;
    sph_pixel_description_table* pdt = NULL;
    cpl_property* prop1 = NULL;
    cpl_property* prop2 = NULL;

    cpl_test_error(CPL_ERROR_NONE);
    pdt = sph_pixel_description_table_new_from_model(insmodel->lensmodel, 0.0,
            0.0);
    mframe = sph_filemanager_create_temp_frame(
            "master_wpdt_for_ifs_science_dr_test.fits",
            SPH_IFS_TAG_WAVE_CALIB_CALIB, CPL_FRAME_GROUP_CALIB);
    sph_pixel_description_table_save(pdt, cpl_frame_get_filename(mframe),
            insmodel->lensmodel);
    prop1 = cpl_property_new(SPH_COMMON_KEYWORD_SPH_DITHERX, CPL_TYPE_DOUBLE);
    prop2 = cpl_property_new(SPH_COMMON_KEYWORD_SPH_DITHERY, CPL_TYPE_DOUBLE);
    cpl_property_set_double(prop1, insmodel->lensmodel->zero_offsetx);
    cpl_property_set_double(prop2, insmodel->lensmodel->zero_offsety);
    sph_fits_update_property(cpl_frame_get_filename(mframe), prop1, 0);
    sph_fits_update_property(cpl_frame_get_filename(mframe), prop2, 0);
    sph_pixel_description_table_delete(pdt);
    pdt = NULL;
    cpl_property_delete(prop1);
    prop1 = NULL;
    cpl_property_delete(prop2);
    prop2 = NULL;
    cpl_test_error(CPL_ERROR_NONE);
    return mframe;
}
cpl_frame* sph_ifs_test_fixtures_calib_products_pdt(
        sph_test_ifs_instrument_model* insmodel) {
    cpl_frame* mframe = NULL;
    sph_pixel_description_table* pdt = NULL;
    cpl_property* prop1 = NULL;
    cpl_property* prop2 = NULL;

    cpl_test_error(CPL_ERROR_NONE);
    pdt = sph_pixel_description_table_new_from_model(insmodel->lensmodel, 0.0,
            0.0);
    mframe = sph_filemanager_create_temp_frame(
            "master_pdt_for_ifs_science_dr_test.fits",
            SPH_IFS_TAG_SPEC_POS_CALIB, CPL_FRAME_GROUP_CALIB);
    sph_pixel_description_table_save(pdt, cpl_frame_get_filename(mframe),
            insmodel->lensmodel);
    prop1 = cpl_property_new(SPH_COMMON_KEYWORD_SPH_DITHERX, CPL_TYPE_DOUBLE);
    prop2 = cpl_property_new(SPH_COMMON_KEYWORD_SPH_DITHERY, CPL_TYPE_DOUBLE);
    cpl_property_set_double(prop1, insmodel->lensmodel->zero_offsetx);
    cpl_property_set_double(prop2, insmodel->lensmodel->zero_offsety);
    sph_fits_update_property(cpl_frame_get_filename(mframe), prop1, 0);
    sph_fits_update_property(cpl_frame_get_filename(mframe), prop2, 0);
    sph_pixel_description_table_delete(pdt);
    pdt = NULL;
    cpl_property_delete(prop1);
    prop1 = NULL;
    cpl_property_delete(prop2);
    prop2 = NULL;
    cpl_test_error(CPL_ERROR_NONE);
    return mframe;
}

cpl_frame* sph_ifs_test_fixtures_calib_products_dff_short(
        sph_test_ngc_ir_simulator* ngc) {
    cpl_image* dff = NULL;
    cpl_frame* mframe = NULL;
    sph_master_frame* masterdff = NULL;

    cpl_test_error(CPL_ERROR_NONE);
    sph_test_ngc_ir_simulator_set_dff_gradient(ngc, 10.0, 100.0);
    dff = sph_test_ngc_ir_simulator_create_detector_flat_image(ngc);
    mframe = sph_filemanager_create_temp_frame(
            "master_dff_short_for_ifs_science_dr_test.fits",
            SPH_IFS_TAG_DFF_SHORT_CALIB, CPL_FRAME_GROUP_CALIB);
    masterdff = sph_master_frame_new_from_cpl_image(dff);
    sph_master_frame_save(masterdff, cpl_frame_get_filename(mframe), NULL);
    sph_master_frame_delete(masterdff);
    masterdff = NULL;
    cpl_image_delete(dff);
    cpl_test_error(CPL_ERROR_NONE);
    return mframe;
}
cpl_frame*
sph_ifs_test_fixtures_calib_products_dff_long(sph_test_ngc_ir_simulator* ngc,
        double min, double max, double lambda, int lamp_id) {
    cpl_image* dff = NULL;
    cpl_frame* mframe = NULL;
    sph_master_frame* masterdff = NULL;
    cpl_property* prop1 = NULL;
    cpl_property* prop2 = NULL;
    const char* tag;

    cpl_test_error(CPL_ERROR_NONE);
    sph_test_ngc_ir_simulator_set_dff_gradient(ngc, min, max);
    dff = sph_test_ngc_ir_simulator_create_detector_flat_image(ngc);
    if ( lamp_id < 2 )
    	tag = SPH_IFS_TAG_DFF_LONG1_CALIB;
    if ( lamp_id == 2)
    	tag = SPH_IFS_TAG_DFF_LONG2_CALIB;
    if ( lamp_id == 3)
       	tag = SPH_IFS_TAG_DFF_LONG3_CALIB;
    if ( lamp_id == 4)
       	tag = SPH_IFS_TAG_DFF_LONG4_CALIB;
    mframe = sph_filemanager_create_temp_frame(
            "master_dff_long_for_ifs_science_dr_test.fits",
            tag, CPL_FRAME_GROUP_CALIB);
    masterdff = sph_master_frame_new_from_cpl_image(dff);
    sph_master_frame_save(masterdff, cpl_frame_get_filename(mframe), NULL);
    prop1 = cpl_property_new(SPH_COMMON_KEYWORD_LAMP, CPL_TYPE_INT);
    cpl_property_set_int(prop1, lamp_id);
    sph_fits_update_property(cpl_frame_get_filename(mframe), prop1, 0);
    prop2 = cpl_property_new(SPH_COMMON_KEYWORD_CALIB_LAMBDA, CPL_TYPE_DOUBLE);
    cpl_property_set_double(prop2, lambda);
    sph_fits_update_property(cpl_frame_get_filename(mframe), prop2, 0);
    sph_master_frame_delete(masterdff);
    masterdff = NULL;
    cpl_image_delete(dff);
    cpl_property_delete(prop1);
    prop1 = NULL;
    cpl_property_delete(prop2);
    prop2 = NULL;
    cpl_test_error(CPL_ERROR_NONE);
    return mframe;
}

cpl_frame*
sph_ifs_test_fixtures_calib_products_ifu_flat(sph_test_ngc_ir_simulator* ngc,
        sph_test_ifs_instrument_model* insmodel) {
    cpl_image* flatin = NULL;
    cpl_image* pdtim = NULL;
    sph_pixel_description_table* pdt = NULL;
    sph_master_frame* ifu_flat = NULL;
    sph_ldt* ldt = NULL;
    cpl_frame* mframe = NULL;
    cpl_table* tab = NULL;
    cpl_test_error(CPL_ERROR_NONE);
    flatin = sph_test_image_tools_create_flat_image_double(ngc->det_size_x,
            ngc->det_size_y, 2000.0);
    pdtim = sph_test_ifs_instrument_model_disperse(insmodel, flatin, 0.0, 0.0);
    pdt = sph_pixel_description_table_new_from_model(insmodel->lensmodel, 0.0,
            0.0);
    ldt = sph_ldt_new_from_pdt_image(pdt,
            sph_ifs_lenslet_model_duplicate(insmodel->lensmodel), pdtim);
    ifu_flat = sph_ldt_collapse(ldt, 0.0, 1.0);

    mframe = sph_filemanager_create_temp_frame(
            "master_ifu_for_ifs_science_dr_test.fits",
            SPH_IFS_TAG_IFU_FLAT_CALIB, CPL_FRAME_GROUP_CALIB);

    tab = sph_ifs_instrument_flat_create_ifu_tab(ldt);
    sph_master_frame_save(ifu_flat, cpl_frame_get_filename(mframe), NULL);
    cpl_table_save(tab, NULL, NULL, cpl_frame_get_filename(mframe),
            CPL_IO_EXTEND);
    sph_ldt_delete(ldt);
    cpl_image_delete(flatin);
    cpl_image_delete(pdtim);
    sph_master_frame_delete(ifu_flat);
    sph_pixel_description_table_delete(pdt);
    cpl_table_delete(tab);
    cpl_test_error(CPL_ERROR_NONE);
    return mframe;
}

sph_ldt*
sph_ifs_test_fixtures_calib_products_simple_ldt(sph_test_ngc_ir_simulator * ngc,
        sph_test_ifs_instrument_model * insmodel) {
    cpl_image *flatin = NULL;
    sph_pixel_description_table *pdt = NULL;
    cpl_image *pdtim = NULL;
    sph_ldt *ldt = NULL;
    cpl_test_error(CPL_ERROR_NONE);

    flatin = sph_test_image_tools_create_flat_image_double(ngc->det_size_x,
            ngc->det_size_y, 2000.0);
    pdtim = sph_test_ifs_instrument_model_disperse(insmodel, flatin, 0.0, 0.0);

    pdt = sph_pixel_description_table_new_from_model(insmodel->lensmodel, 0.0,
            0.0);
    ldt = sph_ldt_new_from_pdt_image(pdt,
            sph_ifs_lenslet_model_duplicate(insmodel->lensmodel), pdtim);

    cpl_image_delete(flatin);
    cpl_image_delete(pdtim);
    sph_pixel_description_table_delete(pdt);
    cpl_test_error(CPL_ERROR_NONE);
    return ldt;
}

/**@}*/
