/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef CUTEST_SPH_FILTER_GENERATION_H_
#define CUTEST_SPH_FILTER_GENERATION_H_

#include <stdio.h>
#include <cpl.h>

typedef enum{
	SPH_FILTER_GENERATION_ARM_IRDIS,
	SPH_FILTER_GENERATION_ARM_ZIMPOL
}sph_filter_generation_arm;

void sph_filter_doit(const char  * path,
		     const char  * base,
		     const char  * pipeid,
		     const char ** ndlab,
		     const size_t  nd_size,
		     const char ** cllab,
		     const size_t  cl_size,
		     const double**  nd,
		     cpl_boolean   doit,
		     const char * catg,
			 const sph_filter_generation_arm arm);

void sph_filter_plist_append_double_value_and_comment(cpl_propertylist * plist, const char * key,
		const double value, const char * comment);

void sph_filter_plist_append_string_value_and_comment(cpl_propertylist * plist, const char * key,
		const char * value, const char * comment);

#endif /* CUTEST_SPH_FILTER_GENERATION_H_ */
