!$Id: visir_spc_wcal.prg,v 1.1.1.1 2007-09-04 09:00:39 llundin Exp $
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!COPYRIGHT (c) 2004 European Southern Observatory
!LICENSE
!
!PROJECT:   VLT Data Flow System
!AUTHOR:    Y. Jung - ESO/DMD/DFS
!SUBSYSTEM: VISIR Instrument Pipeline
!PURPOSE:   MIDAS interface procedure for VISIR pipeline recipe.
!
!$Name: not supported by cvs2svn $
!$Revision: 1.1.1.1 $
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

define/local recipeName/c/1/30 "visir_spc_wcal"

define/local inputFrames/c/1/150 "{P1}"
define/local resultFrames/c/1/150 "{P2}"
define/local calibData/c/1/150 "{P3}"

if calibData .ne. "?" then
    define/local recipeSpecs/c/1/150 " {recipeName} {inputFrames} {calibData}"
else
    define/local recipeSpecs/c/1/150 " {recipeName} {inputFrames}"
endif

define/local didPath/c/1/200 " -I"
define/local didList/c/1/200 " -D"
define/local pafList/c/1/200 " -p *.paf"

define/local proPrefixOption/c/1/20 " --output-prefix="
define/local logFileOption/c/1/20 " --log-file="
define/local recInstOption/c/1/20 " --recipe-dir="

define/local proDir/c/1/60 ""
define/local proPrefix/c/1/60 ""
define/local logFile/c/1/60 ""
define/local recipeInst/c/1/60 "$PIPE_HOME/visir"

define/local cmdLine/c/1/400 " " all
define/local pos/i/1/1 0

log/rec {recipeName} IN

pos = m$indexb(resultFrames, "/") - 1

proDir = resultFrames(1:{pos})
pos = pos + 2
proPrefix = resultFrames({pos}:)
logFile = proPrefix // ".log"

cmdLine = "esorex --output-dir=" // proDir -
          // recInstOption // recipeInst -
          // proPrefixOption // proPrefix -
          // logFileOption // logFile // recipeSpecs

outputi = m$system(cmdLine)
if outputi(1) .ne. 0 then
  return 1
endif

didPath(5:) = m$symbol("INS_ROOT") // "/SYSTEM/Dictionary"
didList(5:) = "PRO,ASM,DPR,GEN,IRD,OBS,PRIMARY-FITS,TCS,TPL,VISIR_ICS"
cmdLine = "QC1LogWriter -s VISIR" // didPath // didList // pafList
outputi = m$system(cmdLine)

if outputi(1) .ne. 0 then
  return 1
endif

log/rec {recipeName} OUT
