import sys, getopt, os
from astropy.io import fits
from astropy.table import Table

'''
###############################################################################
#   General Information
###############################################################################

Use the recipe esotk_eop from the ESOTK pipeline to download and generate the
file esotk_eop_param.fits (see ESOTK documentation for details).

Run 
    python3 cr2res_gen_eop_table.py -i /home/.../esotk_eop_param.fits

    --> Creates cr2res_io_eop_table.h that needs to be put in
        cr2rep/cr2res/
'''

### Global variables
OUTFILE = "cr2res_io_eop_table.h"

'''
###############################################################################
#   Main
###############################################################################
'''
def main(argv):
    # Parse Inputs
    inputfile = ''
    opts, args = getopt.getopt(argv,"hi:",["ifile="])
    for opt, arg in opts:
        if opt == '-h':
            print('cr2res_gen_eop_table.py -i <inputfile>')
            sys.exit()
        elif opt in ("-i", "--ifile"):
            inputfile = arg

    # Check if input file is provided and exists
    if not os.path.isfile(inputfile):
        print("Please provide an existing input FITS file")
        sys.exit()

    # Opening input FITS file
    with fits.open(inputfile) as hdu:
        eop_table = Table(hdu[1].data)
 
    # Opening output C file
    c_file = open(OUTFILE, 'w')

    # Get the number of rows
    nb_rows = len(eop_table)

    # Print header
    c_file.write('''
/* This file is automatically generated with cr2res_gen_eop_table.py */

#ifndef CRIRES_IO_EOP_TABLE_H
#define CRIRES_IO_EOP_TABLE_H

#define     EOP_TABLE_SIZE     {}
static double eop_table_double_entries[EOP_TABLE_SIZE][4]={{
'''.format(nb_rows))

    # Print Values
    for row_idx in range(nb_rows):
        if row_idx == nb_rows-1:
            c_file.write("            {{ {}, {}, {}, {}}}".format(
                        eop_table[row_idx][0],
                        eop_table[row_idx][1],
                        eop_table[row_idx][2],
                        eop_table[row_idx][3]))
        else:
            c_file.write("            {{ {}, {}, {}, {}}},\n".format(
                        eop_table[row_idx][0],
                        eop_table[row_idx][1],
                        eop_table[row_idx][2],
                        eop_table[row_idx][3]))

    c_file.write('''
} ;

static const char * eop_table_string_entries[EOP_TABLE_SIZE]={
''')

    # Print Values
    for row_idx in range(nb_rows):
        if row_idx == nb_rows-1:
            c_file.write('            "{}"'.format(
                        eop_table[row_idx][4]))
        else:
            c_file.write('            "{}",\n'.format(
                        eop_table[row_idx][4]))

    c_file.write('''
} ;

#endif
            '''
            )

    # Closing files
    c_file.close()
    hdu.close()

if __name__ == "__main__":
   main(sys.argv[1:])



