# EFOSC_SET_PREFIX(PREFIX)
#-------------------------
AC_DEFUN([EFOSC_SET_PREFIX],
[
    unset CDPATH
    # make $PIPE_HOME the default for the installation
    AC_PREFIX_DEFAULT($1)

    if test "x$prefix" = "xNONE"; then
        prefix=$ac_default_prefix
        ac_configure_args="$ac_configure_args --prefix $prefix"
    fi

    if test "x$exec_prefix" = "xNONE"; then
        exec_prefix=$prefix
    fi

])


AC_DEFUN([EFOSC_SET_SEX_PREFIX],
[
    if test "x$exec_prefix" != "xNONE"; then
        sex_exec_prefix=$exec_prefix/lib/${PACKAGE}-${VERSION}/bin
        ac_configure_args="$ac_configure_args SEXBINPATH=$sex_exec_prefix"
    elif test "x$prefix" != "xNONE"; then
        sex_exec_prefix=$prefix/lib/${PACKAGE}-${VERSION}/bin
        ac_configure_args="$ac_configure_args SEXBINPATH=$sex_exec_prefix"
    else
        sex_exec_prefix=$ac_default_prefix/lib/${PACKAGE}-${VERSION}/bin
        ac_configure_args="$ac_configure_args SEXBINPATH=$sex_exec_prefix"
    fi
])


# EFOSC_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#--------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([EFOSC_SET_VERSION_INFO],
[
    efosc_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    efosc_major_version=`echo "$efosc_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    efosc_minor_version=`echo "$efosc_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    efosc_micro_version=`echo "$efosc_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$efosc_major_version"; then
        efosc_major_version=0
    fi

    if test -z "$efosc_minor_version"; then
        efosc_minor_version=0
    fi

    if test -z "$efosc_micro_version"; then
        efosc_micro_version=0
    fi

    EFOSC_VERSION="$efosc_version"
    EFOSC_MAJOR_VERSION=$efosc_major_version
    EFOSC_MINOR_VERSION=$efosc_minor_version
    EFOSC_MICRO_VERSION=$efosc_micro_version

    if test -z "$4"; then
        EFOSC_INTERFACE_AGE=0
    else
        EFOSC_INTERFACE_AGE="$4"
    fi

    EFOSC_BINARY_AGE=`expr 100 '*' $EFOSC_MINOR_VERSION + $EFOSC_MICRO_VERSION`
    EFOSC_BINARY_VERSION=`expr 10000 '*' $EFOSC_MAJOR_VERSION + \
                          $EFOSC_BINARY_AGE`

    AC_SUBST(EFOSC_VERSION)
    AC_SUBST(EFOSC_MAJOR_VERSION)
    AC_SUBST(EFOSC_MINOR_VERSION)
    AC_SUBST(EFOSC_MICRO_VERSION)
    AC_SUBST(EFOSC_INTERFACE_AGE)
    AC_SUBST(EFOSC_BINARY_VERSION)
    AC_SUBST(EFOSC_BINARY_AGE)

    AC_DEFINE_UNQUOTED(EFOSC_MAJOR_VERSION, $EFOSC_MAJOR_VERSION,
                       [EFOSC2 pipeline major version number])
    AC_DEFINE_UNQUOTED(EFOSC_MINOR_VERSION, $EFOSC_MINOR_VERSION,
                       [EFOSC2 pipeline minor version number])
    AC_DEFINE_UNQUOTED(EFOSC_MICRO_VERSION, $EFOSC_MICRO_VERSION,
                       [EFOSC2 pipeline micro version number])
    AC_DEFINE_UNQUOTED(EFOSC_INTERFACE_AGE, $EFOSC_INTERFACE_AGE,
                       [EFOSC2 pipeline interface age])
    AC_DEFINE_UNQUOTED(EFOSC_BINARY_VERSION, $EFOSC_BINARY_VERSION,
                       [EFOSC2 pipeline binary version number])
    AC_DEFINE_UNQUOTED(EFOSC_BINARY_AGE, $EFOSC_BINARY_AGE,
                       [EFOSC2 pipeline binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# EFOSC_SET_PATHS
#----------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([EFOSC_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$privatelibdir"; then
        privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi

    if test -z "$apidocdir"; then
        apidocdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}/html'
    fi

    if test -z "$pipedocsdir"; then
        pipedocsdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}/'
    fi

    if test -z "$configdir"; then
       configdir='${prefix}/share/esopipes/${PACKAGE}-${VERSION}/config'
    fi

    if test -z "$wkfextradir"; then
        wkfextradir='${datadir}/esopipes/${PACKAGE}-${VERSION}/reflex'
    fi

    if test -z "$wkfcopydir"; then
        wkfcopydir='${datadir}/reflex/workflows/${PACKAGE}-${VERSION}'
    fi

    if test -z "$workflowdir"; then
        workflowdir='${datadir}/esopipes/workflows/${PACKAGE}-${VERSION}/${PACKAGE}'
    fi

    if test -z "$reportsdir"; then
        reportsdir='${datadir}/esopipes/reports/${PACKAGE}-${VERSION}'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(privatelibdir)
    AC_SUBST(apidocdir)
    AC_SUBST(pipedocsdir)
    AC_SUBST(configdir)
    AC_SUBST(wkfextradir)
    AC_SUBST(wkfcopydir)
    AC_SUBST(workflowdir)
    AC_SUBST(reportsdir)

    # Define the preprocessor symbols for the sextractor executable
    # and the configuration files.

    eval sext_bindir="${prefix}/lib/${PACKAGE}-${VERSION}/bin"

    AC_DEFINE_UNQUOTED(EFOSC_SEXTRACTOR_PATH, "$sext_bindir",
                       [Absolute path to the sextractor executable])

    eval d="$configdir"
    eval sext_configdir="$d"

    AC_DEFINE_UNQUOTED(EFOSC_SEXTRACTOR_CONFIG, "$sext_configdir",
                       [Absolute path to the sextractor configuration files])

])


# EFOSC_CREATE_SYMBOLS
#---------------------
# Define include and library related makefile symbols
AC_DEFUN([EFOSC_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    EFOSC_INCLUDES='-I$(top_srcdir)/efosc'
    EFOSC_LDFLAGS='-L$(top_builddir)/efosc'

    #WCSLIB_LDFLAGS='-L$(top_builddir)/wcslib-4.2/C'
    #WCSLIB_INCLUDES='-I$(top_srcdir)/wcslib-4.2/C'

    # Library aliases

    LIBEFOSC='$(top_builddir)/efosc/libefosc.la'
    #LIBWCSLIB='$(top_builddir)/wcslib-4.2/C/libwcs-4.2.a'

    # Substitute the defined symbols

    AC_SUBST(EFOSC_INCLUDES)
    AC_SUBST(EFOSC_LDFLAGS)
    AC_SUBST(LIBEFOSC)

    #AC_SUBST(WCSLIB_INCLUDES)
    #AC_SUBST(WCSLIB_LDFLAGS)
    #AC_SUBST(LIBWCSLIB)

    # Check for CPL and user defined libraries
    AC_REQUIRE([CPL_CHECK_LIBS])
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(EFOSC_INCLUDES) $(CPL_INCLUDES) $(CX_INCLUDES) $(EXTRA_INCLUDES)'
    all_ldflags='$(EFOSC_LDFLAGS) $(CPL_LDFLAGS) $(CX_LDFLAGS) $(EXTRA_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)

])

