from edps import SCIENCE, QC1_CALIB, task, match_rules, RelativeTimeRange

from .efosc_common import task_bias
from .efosc_datasources import *
from .efosc_task_functions import which_insmode, is_lss, is_mos

__title__ = "EFOSC SPECTROSCOPIC workflow"

task_calib_spectra = (task("spectroscopic_calibrations")
                      .with_recipe("efosc_calib")
                      .with_main_input(raw_screen_flat)
                      .with_associated_input(task_bias, [MASTER_BIAS], min_ret=1)
                      .with_associated_input(raw_wave, min_ret=1)
                      .with_associated_input(master_linecat, min_ret=1)
                      .with_associated_input(grism_table, min_ret=1)
                      .with_meta_targets([QC1_CALIB])
                      .build())

assoc_lss_calibrations = (match_rules()
                          .with_match_function(rules.is_assoc_screen_flat_lss, time_range=RelativeTimeRange(-3, 3),
                                               level=0)
                          .with_match_function(rules.is_assoc_screen_flat_lss, time_range=UNLIMITED, level=3))

assoc_mos_calibrations = (match_rules()
                          .with_match_function(rules.is_assoc_screen_flat_mos, time_range=RelativeTimeRange(-3, 3),
                                               level=0)
                          .with_match_function(rules.is_assoc_screen_flat_mos, time_range=UNLIMITED, level=3))

# --- process rawstandard star ----------------------------------------------------------------------------
task_standard = (task("spectroscopic_standard")
                 .with_recipe("efosc_science")
                 .with_main_input(raw_std_spectra)
                 .with_associated_input(task_bias, [MASTER_BIAS], min_ret=1)
                 .with_associated_input(task_calib_spectra,
                                        [pcls_master_norm_flat_lss, pcls_disp_coeff_lss,
                                         pcls_slit_location_lss], match_rules=assoc_lss_calibrations)
                 .with_associated_input(grism_table)
                 .with_associated_input(extinction_table)
                 .with_associated_input(std_flux_table)
                 .with_meta_targets([QC1_CALIB])
                 .build())

# --- proces science spectra -----
task_science = (task("science_spectrum")
                .with_recipe("efosc_science")
                .with_main_input(raw_science_spec)
                .with_associated_input(task_bias, [MASTER_BIAS], min_ret=1)
                .with_associated_input(task_calib_spectra,
                                       [pcls_master_norm_flat_lss, pcls_disp_coeff_lss, pcls_slit_location_lss],
                                       condition=is_lss, match_rules=assoc_lss_calibrations)
                .with_associated_input(task_calib_spectra,
                                       [pcls_master_norm_flat_mos, pcls_disp_coeff_mos, pcls_slit_location_mos,
                                        pcls_curv_coeff_mos], condition=is_mos, match_rules=assoc_mos_calibrations)
                .with_associated_input(task_standard, [pcls_specphot_table], min_ret=0)
                .with_associated_input(grism_table)
                .with_associated_input(extinction_table, min_ret=0)
                .with_dynamic_parameter("insmode", which_insmode)
                .with_input_filter(pcls_master_norm_flat_lss, pcls_disp_coeff_lss, pcls_slit_location_lss,
                                   pcls_master_norm_flat_mos, pcls_disp_coeff_mos, pcls_slit_location_mos,
                                   pcls_curv_coeff_mos,
                                   pcls_specphot_table, MASTER_BIAS, GRISM_TABLE, EXTINCTION_TABLE)
                .with_meta_targets([SCIENCE])
                .build())
