# ESO_PROG_CC_FLAG(FLAG, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#-----------------------------------------------------------------
AC_DEFUN([ESO_PROG_CC_FLAG],
[
    AC_REQUIRE([AC_PROG_CC])

    flag=`echo $1 | sed 'y%.=/+-%___p_%'`
    AC_CACHE_CHECK([whether $CC supports -$1],
                   [eso_cv_prog_cc_$flag],
                   [
                       eval "eso_cv_prog_cc_$flag=no"
                       AC_LANG_PUSH(C)

                       echo 'int main() { return 0; }' >conftest.$ac_ext

                       try_compile="`$CC -$1 -c conftest.$ac_ext 2>&1`"
                       if test -z "$try_compile"; then
                           try_link="`$CC -$1 -o conftest$ac_exeext \
                                    conftest.$ac_ext 2>&1`"
                           if test -z "$try_link"; then
                               eval "eso_cv_prog_cc_$flag=yes"
                           fi
                       fi
                       rm -f conftest*

                       AC_LANG_POP(C)
                   ])

    if eval "test \"`echo '$eso_cv_prog_cc_'$flag`\" = yes"; then
        :
        $2
    else
        :
        $3
    fi
])
