/* $Id: efosc_data.h,v 1.2 2009-07-10 09:27:59 cizzo Exp $
 *
 * This file is part of the EFOSC Library
 * Copyright (C) 2009 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: cizzo $
 * $Date: 2009-07-10 09:27:59 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef EFOSC_DATA_H
#define EFOSC_DATA_H

#include <efosc_std_star.h>
#include <efosc_setting.h>

#include <cpl.h>

/* Photometry table column names */
extern const char *const EFOSC_DATA_PHOT_FILTER;
extern const char *const EFOSC_DATA_PHOT_EXTCOEFF;
extern const char *const EFOSC_DATA_PHOT_DEXTCOEFF;
extern const char *const EFOSC_DATA_PHOT_ZEROPOINT;
extern const char *const EFOSC_DATA_PHOT_DZEROPOINT;
extern const char *const EFOSC_DATA_PHOT_COLORTERM;
extern const char *const EFOSC_DATA_PHOT_DCOLORTERM;

void
efosc_std_star_list_apply_wcs(efosc_std_star_list    *stars,
                              const cpl_propertylist *header);

void efosc_phot_table_load(const   cpl_frame *phot_table_frame,
                           const   efosc_setting *setting,
                           double *color_term,
                           double *dcolor_term,
                           double *ext_coeff,
                           double *dext_coeff,
                           double *expected_zeropoint,
                           double *dexpected_zeropoint);

cpl_table *efosc_phot_coeff_create(const  efosc_setting *,
                                   double color_term,
                                   double dcolor_term,
                                   double ext_coeff,
                                   double dext_coeff,
                                   double zeropoint,
                                   double dzeropoint);

#endif
