/* $Id: efosc_instrument.h,v 1.1 2009-07-10 09:24:19 cizzo Exp $
 *
 * This file is part of the EFOSC Library
 * Copyright (C) 2009 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: cizzo $
 * $Date: 2009-07-10 09:24:19 $
 * $Revision: 1.1 $
 * $Name: not supported by cvs2svn $
 */

#ifndef EFOSC_INSTRUMENT_H
#define EFOSC_INSTRUMENT_H

#include <efosc_setting.h>
#include <stdbool.h>
#include <cpl.h>

char
efosc_instrument_filterband_get_by_setting(  const efosc_setting  *setting);

char
efosc_instrument_filterband_get_by_name(     const char  *filtername);

bool
efosc_instrument_filterband_is_defined(      char    band);

bool
efosc_instrument_filterband_is_none(         char    band);

bool
efosc_instrument_filterband_is_unknown(      char    band);

char
efosc_instrument_filterband_value_unknown(   void);

int
efosc_instrument_known_filters_get_number(   void);

const char  *
efosc_instrument_known_filters_get_name(     int n);

char
efosc_instrument_known_filters_get_band(     int n);

#endif  /* EFOSC_INSTRUMENT_H */
