/* $Id: efosc_paf.h,v 1.1.1.1 2008-12-25 15:10:18 cizzo Exp $
 *
 * This file is part of the EFOSC2 Library
 * Copyright (C) 2000-2006 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: cizzo $
 * $Date: 2008-12-25 15:10:18 $
 * $Revision: 1.1.1.1 $
 * $Name: not supported by cvs2svn $
 */
 
#ifndef EFOSC_PAF_H
#define EFOSC_PAF_H

#include <sys/types.h>

#include <cpl.h>


CPL_BEGIN_DECLS

/*
 * Maximum length of a parameter file record, i.e. maximum number of
 * characters per line of a parameter file on disk. This does not include
 * a trailing 0.
 */

#define PAF_RECORD_MAX  (256)


/*
 * PAF value types
 */

enum _EFOSC_PAF_TYPE_ {
    PAF_TYPE_NONE,
    PAF_TYPE_BOOL,
    PAF_TYPE_INT,
    PAF_TYPE_DOUBLE,
    PAF_TYPE_STRING
};

typedef enum _EFOSC_PAF_TYPE_ EfoscPAFType;

/*
 * PAF object
 */

typedef struct _EFOSC_PAF_ EfoscPAF;

/*
 * Create, copy and destroy operations
 */

EfoscPAF *newEfoscPAF(const char *, const char *, const char *,
                          const char *);
void deleteEfoscPAF(EfoscPAF *);

/*
 * Nonmodifying operations
 */

int efoscPAFIsEmpty(const EfoscPAF *);
size_t efoscPAFGetSize(const EfoscPAF *);
int efoscPAFContains(const EfoscPAF *, const char *);
size_t efoscPAFCount(const EfoscPAF *, const char *);

/*
 * Header operations
 */

EfoscPAFType efoscPAFType(const EfoscPAF *, const char *);

const char *efoscPAFGetName(const EfoscPAF *);
const char *efoscPAFGetTag(const EfoscPAF *);
const char *efoscPAFGetId(const EfoscPAF *);
const char *efoscPAFGetDescription(const EfoscPAF *);

int efoscPAFSetName(EfoscPAF *, const char *);
int efoscPAFSetTag(EfoscPAF *, const char *);
int efoscPAFSetId(EfoscPAF *, const char *);
int efoscPAFSetDescription(EfoscPAF *, const char *);

int efoscPAFSetHeader(EfoscPAF *, const char *, const char *, const char *,
                    const char *);

/*
 * Element access
 */

int efoscPAFGetValueBool(const EfoscPAF *, const char *);
int efoscPAFGetValueInt(const EfoscPAF *, const char *);
double efoscPAFGetValueDouble(const EfoscPAF *, const char *);
const char *efoscPAFGetValueString(const EfoscPAF *, const char *);
const char *efoscPAFGetComment(const EfoscPAF *, const char *);

int efoscPAFSetValueBool(EfoscPAF *, const char *, int);
int efoscPAFSetValueInt(EfoscPAF *, const char *, int);
int efoscPAFSetValueDouble(EfoscPAF *, const char *, double);
int efoscPAFSetValueString(EfoscPAF *, const char *, const char *);
int efoscPAFSetComment(EfoscPAF *, const char *, const char *);

/*
 * Inserting and removing elements
 */

int efoscPAFInsertBool(EfoscPAF *, const char *, const char *, int, const char *);
int efoscPAFInsertInt(EfoscPAF *, const char *, const char *, int, const char *);
int efoscPAFInsertDouble(EfoscPAF *, const char *, const char *, double,
                       const char *);
int efoscPAFInsertString(EfoscPAF *, const char *, const char *, const char *,
                       const char *);

int efoscPAFInsertAfterBool(EfoscPAF *, const char *, const char *, int,
                          const char *);
int efoscPAFInsertAfterInt(EfoscPAF *, const char *, const char *, int,
                         const char *);
int efoscPAFInsertAfterDouble(EfoscPAF *, const char *, const char *, double,
                            const char *);
int efoscPAFInsertAfterString(EfoscPAF *, const char *, const char *,
                            const char *, const char *);

int efoscPAFPrependBool(EfoscPAF *, const char *, int, const char *);
int efoscPAFPrependInt(EfoscPAF *, const char *, int, const char *);
int efoscPAFPrependDouble(EfoscPAF *, const char *, double, const char *);
int efoscPAFPrependString(EfoscPAF *, const char *, const char *, const char *);

int efoscPAFAppendBool(EfoscPAF *, const char *, int, const char *);
int efoscPAFAppendInt(EfoscPAF *, const char *, int, const char *);
int efoscPAFAppendDouble(EfoscPAF *, const char *, double, const char *);
int efoscPAFAppendString(EfoscPAF *, const char *, const char *, const char *);

void efoscPAFErase(EfoscPAF *, const char *);
void efoscPAFClear(EfoscPAF *);

/*
 * Read and write operations
 */

int efoscPAFWrite(EfoscPAF *);

/*
 * Miscellaneous utilities
 */

int efoscPAFIsValidName(const char *);

CPL_END_DECLS

#endif /* EFOSC_PAF_H */
