/* $Id: efosc_point.c,v 1.1.1.1 2008-12-25 15:10:18 cizzo Exp $
 *
 * This file is part of the EFOSC2 library
 * Copyright (C) 2002-2006 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: cizzo $
 * $Date: 2008-12-25 15:10:18 $
 * $Revision: 1.1.1.1 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <efosc_point.h>

#include <efosc_utils.h>

/**
 * @defgroup efosc_point   2d point
 */

/**@{*/

#define LIST_DEFINE
#undef LIST_ELEM
#define LIST_ELEM efosc_point
#include <list.h>

/**
 * @brief  Constructor
 * @param  x          1st coordinate
 * @param  y          2nd coordinate
 * @return  newly allocated point
 */
efosc_point *efosc_point_new(double x, double y)
{
    efosc_point *p = cpl_malloc(sizeof(*p));

    p->x = x;
    p->y = y;

    return p;    
}

#undef cleanup
#define cleanup
/**
 * @brief  Copy constructor
 * @param  p       to duplicate
 * @return  newly allocated point
 */
efosc_point *efosc_point_duplicate(const efosc_point *p)
{
    efosc_point *p2 = NULL;
    
    assure( p != NULL, return p2, NULL );

    p2 = cpl_malloc(sizeof(*p2));
    p2->x = p->x;
    p2->y = p->y;

    return p2;
}

/**
 * @brief  Destructor
 * @param  p       to delete
 */
void efosc_point_delete(efosc_point **p)
{
    if (p && *p) {
        cpl_free(*p); *p = NULL;
    }
    return;
}

#undef cleanup
#define cleanup
/**
 * @brief  Metric
 * @param  p     1st point
 * @param  q     2nd point
 * @return squared distance
 */
double efosc_point_distsq(const efosc_point *p,
			 const efosc_point *q)
{
    assure( p != NULL, return -1, NULL );
    assure( q != NULL, return -1, NULL );

    return (
        (p->x - q->x)*(p->x - q->x) +
        (p->y - q->y)*(p->y - q->y));
}

/**
 * @brief  Equality
 * @param  p     1st point
 * @param  q     2nd point
 * @return true iff points are equal
 */
bool efosc_point_equal(const efosc_point *p,
		      const efosc_point *q)
{
    return efosc_point_distsq(p, q) <= DBL_EPSILON;
}


/**@}*/
