/* $Id: efosc_std_cat.h,v 1.1 2009-07-10 12:35:48 cizzo Exp $
 *
 * This file is part of the EFOSC Library
 * Copyright (C) 2009 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: cizzo $
 * $Date: 2009-07-10 12:35:48 $
 * $Revision: 1.1 $
 * $Name: not supported by cvs2svn $
 */

#ifndef EFOSC_STD_CAT_H
#define EFOSC_STD_CAT_H

#include <efosc_std_star.h>
#include <cpl.h>

extern const char *EFOSC_STD_CAT_COLUMN_RA;
extern const char *EFOSC_STD_CAT_COLUMN_DEC;
extern const char *EFOSC_STD_CAT_COLUMN_NAME;

efosc_std_star_list *
efosc_std_cat_load(                          const cpl_frameset  *cat_frames,
                                            char            band,
                                            bool            require_all_frames,
                                            double          color_term,
                                            double          dcolor_term);

efosc_std_star_list *
efosc_std_cat_load_old(                      const cpl_frameset *cat_frames,
                                            /*const efosc_setting *setting,*/
                                            char  optical_band,
                                            double color_term,
                                            double dcolor_term);

#endif  /* EFOSC_STD_CAT_H */
