/* $Id: efosc_tools.h,v 1.2 2009-07-10 12:54:52 cizzo Exp $
 *
 * This file is part of the EFOSC Library
 * Copyright (C) 2009 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: cizzo $
 * $Date: 2009-07-10 12:54:52 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef EFOSC_TOOLS_H
#define EFOSC_TOOLS_H

#include <efosc_star.h>
#include <efosc_setting.h>
#include <efosc_image.h>
#include <cpl.h>

double
efosc_star_ext_corr(efosc_star_list *stars, 
                   const efosc_setting *setting,
                   double ext_coeff,
		   double dext_coeff,
                   const cpl_frame *raw_frame);

cpl_table *
efosc_create_sources_table(efosc_star_list *sources);

double
efosc_fixed_pattern_noise(const efosc_image *master,
                         double convert_ADU,
                         double master_noise);
double
efosc_fixed_pattern_noise_bias(const efosc_image *first_raw,
                              const efosc_image *second_raw,
                              double ron);
double
efosc_get_airmass(const cpl_propertylist *header);

#endif
