from edps import data_source, THREE_DAYS, FIVE_DAYS, TWO_WEEKS, UNLIMITED, IN_THE_PAST

from .efosc_classification import *

detector_kwd = [kwd.det_read_clock, kwd.det_win1_binx, kwd.det_win1_biny]
grism_and_filter = [kwd.ins_gris1_name, kwd.ins_filt1_name]

# --- COMMON
raw_bias = (data_source("BIAS")
            .with_classification_rule(bias_class)
            .with_setup_keywords(["det.read.clock", "det.win1.binx", "det.win1.biny"])
            .with_grouping_keywords(rules.grpkwd["BIAS"])
            .with_match_keywords(rules.matchkwd["BIAS"], time_range=FIVE_DAYS, level=0)
            .with_match_keywords(rules.matchkwd["BIAS"], time_range=UNLIMITED, level=3)
            .build())

# --- IMAGING

# raw calibrations
raw_skyflat_img = (data_source("SKY_FLAT_IMAGING")
                   .with_classification_rule(skyflat_img_class)
                   .with_setup_keywords(detector_kwd + [kwd.ins_filt1_name])
                   .with_grouping_keywords(rules.grpkwd["FLAT_SKY"])
                   .with_match_keywords(rules.matchkwd["SKY_FLAT_IMG"], time_range=TWO_WEEKS, level=0)
                   .with_match_keywords(rules.matchkwd["SKY_FLAT_IMG"], time_range=UNLIMITED, level=3)
                   .build())

raw_std_img = (data_source("STANDARD_STAR_IMAGING")
               .with_classification_rule(stdandard_imging_class)
               .with_grouping_keywords([kwd.arcfile])
               .build())

raw_science_img = (data_source("SCIENCE_IMAGE")
                   .with_classification_rule(science_img_class)
                   .with_grouping_keywords([kwd.arcfile])
                   .build())

# static calibrations
photTable = (data_source("PHOTOMETRIC_TABLE")
             .with_classification_rule(PHOTOMETRIC_TABLE)
             .with_match_keywords([kwd.instrume], level=0)
             .build())

imaging_catalogue = (data_source("IMAGING_CATALOGUE")
                     .with_classification_rule(STD_FLUX_TABLE_IMG)
                     .with_match_function(rules.match_img_catalog, level=0)
                     .build())

# --- SPECTROSCOPY

# raw calibrations

raw_screen_flat = (data_source("SPECTROSCOPIC_FLAT")
                   .with_classification_rule(cls_screen_flat_mos)
                   .with_classification_rule(cls_screen_flat_lss)
                   .with_grouping_keywords([kwd.tpl_start])
                   .build())

raw_wave = (data_source("WAVELENGTH")
            .with_classification_rule(cls_lamp_lss)
            .with_classification_rule(cls_lamp_mos)
            .with_grouping_keywords([kwd.arcfile])
            .with_match_function(rules.is_assoc_lamp, time_range=THREE_DAYS, level=0)
            .with_match_function(rules.is_assoc_lamp, time_range=UNLIMITED, level=3)
            .build())

raw_std_spectra = (data_source("SPECTROSCOPIC_STANDARDS")
                   .with_classification_rule(cls_std_spectra)
                   .with_grouping_keywords([kwd.arcfile])
                   .with_match_keywords(grism_and_filter + [kwd.det_chip1_name, kwd.det_win1_binx])
                   .build())

raw_science_spec = (data_source("SCIENCE_SPECTRA")
                    .with_classification_rule(cls_sci)
                    .with_grouping_keywords([kwd.arcfile])
                    .build())

# STATIC calibrations

master_linecat = (data_source("MASTER_LINECAT")
                  .with_classification_rule(LINE_CATALOG)
                  .with_match_keywords([kwd.ins_gris1_name])
                  .build())

grism_table = (data_source("GRISM_TABLE")
               .with_classification_rule(GRISM_TABLE)
               .with_match_keywords(grism_and_filter, time_range=IN_THE_PAST, level=0)
               .with_match_keywords(grism_and_filter, time_range=UNLIMITED, level=0)
               .build())

std_flux_table = (data_source("STANDARDS_FLUX_TABLE")
                  .with_classification_rule(STD_FLUX_TABLE_SPC)
                  .with_match_keywords([kwd.obs_targ_name], time_range=UNLIMITED, level=0)
                  .build())

extinction_table = (data_source("EXTINCTION_TABLE")
                    .with_classification_rule(EXTINCTION_TABLE)
                    .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                    .build())
