from edps import SCIENCE, QC1_CALIB, task

from .efosc_common import task_bias
from .efosc_datasources import *

__title__ = "EFOSC IMAGING workflow"

# Processing tasks
# --- process raw sky flat field --------------------------------------------------------------------------
task_skyflat_img = (task("sky_flat")
                    .with_recipe("efosc_img_sky_flat")
                    .with_main_input(raw_skyflat_img)
                    .with_associated_input(task_bias, [MASTER_BIAS], min_ret=1)
                    .with_meta_targets([QC1_CALIB])
                    .build())

# --- process raw photometric standard star field ----------------------------------------------------------
task_std_img = (task("photometric_standard")
                .with_recipe("efosc_zeropoint")
                .with_main_input(raw_std_img)
                .with_associated_input(task_bias, [MASTER_BIAS], min_ret=1)
                .with_associated_input(task_skyflat_img, [MASTER_SKYFLAT_IMG], min_ret=1)
                .with_associated_input(photTable, min_ret=1)
                .with_associated_input(imaging_catalogue, min_ret=1)
                .with_meta_targets([QC1_CALIB])
                .build())

# --- proces raw science ------------------------------------------------------------------------------------
task_science_img = (task("science_imaging")
                    .with_recipe("efosc_img_science")
                    .with_main_input(raw_science_img)
                    .with_associated_input(task_bias, [MASTER_BIAS], min_ret=1)
                    .with_associated_input(task_skyflat_img, [MASTER_SKYFLAT_IMG], min_ret=1)
                    .with_associated_input(photTable, min_ret=0)
                    .with_meta_targets([SCIENCE])
                    .build())
