from edps import like, match

from . import efosc_keywords as kwd

# dictionary with grouping keywords
grpkwd = dict()
grpkwd["BIAS"] = [kwd.det_read_clock, kwd.det_win1_binx, kwd.det_win1_biny, kwd.tpl_start]
grpkwd["FLAT_SKY"] = [kwd.det_read_clock, kwd.ins_filt1_name, kwd.det_win1_binx, kwd.det_win1_biny, kwd.tpl_start]

# dictionary with matching keywords
matchkwd = dict()
matchkwd["BIAS"] = [kwd.det_read_clock, kwd.det_win1_binx, kwd.det_win1_biny]
matchkwd["SKY_FLAT_IMG"] = [kwd.det_win1_binx, kwd.det_win1_biny, kwd.det_read_clock, kwd.ins_filt1_name]
matchkwd["SPEC"] = [kwd.det_win1_binx, kwd.det_win1_biny, kwd.det_read_clock, kwd.ins_filt1_name, kwd.ins_gris1_name,
                    kwd.ins_gris1_id]
matchkwd["SPECPHOT_TABLE"] = [kwd.det_win1_binx, kwd.det_win1_biny, kwd.ins_filt1_name, kwd.ins_gris1_name,
                              kwd.ins_gris1_id]


# Common classification rules


def is_efosc(f):
    return f[kwd.instrume] == "EFOSC"


def is_calib(f):
    return f[kwd.dpr_catg] == "CALIB"


def is_science(f):
    return f[kwd.dpr_catg] == "SCIENCE"


def is_bias(f):
    return is_calib(f) and f[kwd.dpr_type] == "BIAS" and f[kwd.tpl_nexp] > 3


# classification rules for IMAGING


def is_img_mode(f):
    return is_efosc(f) and f[kwd.dpr_tech] == "IMAGE"


def is_std_img_U(f):
    return is_img_mode(f) and f[kwd.ins_filt1_name] == "U#640"


def is_std_img_BVRI(f):
    return is_img_mode(f) and f[kwd.ins_filt1_name] in ["B#639", "V#641", "R#642", "i#705"]


def is_science_img(f):
    return is_efosc(f) and is_science(f) and is_img_mode(f) and f[kwd.dpr_type] != "STD"


def is_landolt(f):
    return f[kwd.qc_author] == "Landolt" and f[kwd.pro_catg] == "FLX_STD_IMG"


def is_stetson(f):
    return f[kwd.qc_author] == "Stetson" and f[kwd.pro_catg] == "FLX_STD_IMG"


def is_spec(f):
    return f[kwd.dpr_tech] == "SPECTRUM"


def is_mos(f):
    return is_efosc(f) and is_spec(f) and like(f[kwd.ins_slit1_name], "Mos%")


def is_lss(f):
    return is_efosc(f) and is_spec(f) and like(f[kwd.ins_slit1_name], "slit%")


def is_screen_flat_mos(f):
    return is_efosc(f) and is_calib(f) and is_mos(f) and f[kwd.dpr_type] == "FLAT"


def is_screen_flat_lss(f):
    return is_efosc(f) and is_calib(f) and is_lss(f) and f[kwd.dpr_type] == "FLAT" and f[
        kwd.ins_slit1_name] != "slit#5.0"


def is_lamp_lss(f):
    return is_efosc(f) and is_calib(f) and is_lss(f) and f[kwd.dpr_type] == "WAVE" and f[
        kwd.ins_slit1_name] != "slit#5.0"


def is_lamp_mos(f):
    return is_efosc(f) and is_calib(f) and is_mos(f) and f[kwd.dpr_type] == "WAVE"


# association rules:
# ref (1st input): trigger requesting file, e.g. science
# f   (2nd input): requested calibration, e.g., bias

def is_assoc_lamp_mos(ref, f):
    return match(ref, f, matchkwd["SPEC"] + [kwd.ins_slit1_name, kwd.tpl_start])


def is_assoc_lamp_lss(ref, f):
    return match(ref, f, matchkwd["SPEC"] + [kwd.ins_slit1_name, kwd.tpl_start])


def is_assoc_lamp(ref, f):
    return match(ref, f, matchkwd["SPEC"] + [kwd.ins_slit1_name, kwd.tpl_start])


def is_assoc_standard_lss(ref, f):
    return match(ref, f, matchkwd["SPEC"])


def is_assoc_screen_flat_lss(ref, f):
    c1 = match(ref, f, matchkwd["SPEC"])
    c2 = ("slit#1" in f[kwd.ins_slit1_name]) or ("slit#0" in f[kwd.ins_slit1_name])
    return c1 and c2


def is_assoc_screen_flat_mos(ref, f):
    return match(ref, f, matchkwd["SPEC"] + [kwd.ins_slit1_name] + [kwd.ins_slit1_comment1])


def match_img_catalog(ref, f):
    c1 = ref[kwd.ins_filt1_name] == "U#640" and is_landolt(f)
    c2 = ref[kwd.ins_filt1_name] in ["B#639", "V#641", "R#642", "i#705"] and is_stetson(f)
    return c1 or c2
