# Tasks that are in common are imported from the efosc_common module
from edps import FilterMode, CALCHECKER, SCIENCE, task, QC1_CALIB, QC0, ReportInput

from .efosc_common import bias, calibration_std, calibration_mos
from .efosc_datasources import *
from .efosc_task_functions import *

__title__ = "EFOSC spectroscopic workflow"

# --- PROCESSING TASKS -----------------------------------------------------------------------------
imported_tasks = [bias, calibration_std, calibration_mos ]

# --- Tasks for processing the standard stars -----------------------------------------------------
# Processing standard stars for MOS observations
standard_mos = (task('standard_mos')
                .with_recipe('fors_science')
                .with_report("fors_rawdisp", ReportInput.RECIPE_INPUTS)
                .with_main_input(raw_std_mos)
                .with_associated_input(bias, [MASTERBIAS])
                .with_associated_input(calibration_std, [master_norm_flat_mos, disp_coeff_mos,
                                                         slit_location_mos, flat_sed_mos])
                .with_associated_input(grism_table)
                .with_associated_input(std_flux_table)
                .with_associated_input(extinct_table)
                .with_meta_targets([QC1_CALIB, CALCHECKER])
                .build())

# --- Task for processing science observations  ---------------------------------------------------
science = (task('science_spectra')
           .with_recipe('efosc_science')
           .with_main_input(raw_sci)
           .with_dynamic_parameter('ins_mode', which_observation_type)
           .with_associated_input(bias, [MASTERBIAS])
           .with_associated_input(calibration_mos,
                                  [master_norm_flat_mos, disp_coeff_mos, slit_location_mos,
                                   flat_sed_mos, curv_coeff_mos], condition=is_mos)
           .with_associated_input(standard_mos, [specphot_table], condition=is_mos_or_lss)
           .with_associated_input(master_specphot_table, min_ret=0)
           .with_associated_input(grism_table)
           .with_associated_input(extinct_table, min_ret=0)
           .with_associated_input(global_distortion_table, min_ret=0)
           .with_associated_input(master_skylinecat, min_ret=0)
           .with_associated_input(reduced_std, min_ret=0)
           .with_meta_targets([SCIENCE, CALCHECKER, QC0])
           .build())
