from edps import subworkflow, task, QC1_CALIB, ReportInput

from .efosc_datasources import *
from .efosc_task_functions import *


def create_calibration(main_input, bias, wave, ins_mode, task_recipe, maxret):
    task_building = (task('calibration_' + ins_mode)
                     .with_recipe(task_recipe)
                     .with_main_input(main_input)
                     .with_associated_input(wave, max_ret=maxret)
                     .with_associated_input(bias, [MASTERBIAS])
                     .with_associated_input(master_linecat)
                     .with_associated_input(grism_table)
                     .with_dynamic_parameter('ins_mode', which_observation_type)
                     .with_meta_targets([QC1_CALIB]))

    return task_building.build()


# This sub-workflow creates the calibration tasks for the various instrument mode.
@subworkflow("spectra_calibrations", "")
def spectra_calibrations(bias):
    calibration_mos = create_calibration(raw_screen_flat_mos, bias, raw_wave, 'mos', 'efosc_calib', 1)
    calibration_std = create_calibration(raw_screen_flat_std, bias, raw_wave, 'std', 'efosc_calib', 1)

    return calibration_mos, calibration_std
