from edps import JobParameters, ClassifiedFitsFile, List


def which_insmode(files: List[ClassifiedFitsFile]):
    insmode = files[0].get_keyword_value("ins.slit1.name", "none")

    if "slit" in insmode:
        return "LSS"
    elif "Mos" in insmode:
        return "MOS"
    else:
        return "undefined"


def is_lss(param: JobParameters) -> bool:
    insmode = param.get_workflow_param("insmode")
    return insmode == "LSS"


def is_mos(param: JobParameters) -> bool:
    insmode = param.get_workflow_param("insmode")
    return insmode == "MOS"
