
#ifndef ERISP_ERIS_ERIS_IFU_COMBINE_STATIC_H_
#define ERISP_ERIS_ERIS_IFU_COMBINE_STATIC_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define MAX_NAME_SIZE 512
#define KEY_NAME_MJD_OBS "MJD-OBS"

/* Number of tabulations in kernel  */
#define TABSPERPIX      (1000)
#define KERNEL_WIDTH    (2.0)
#define KERNEL_SAMPLES  (1+(int)(TABSPERPIX * KERNEL_WIDTH))
#define TANH_STEEPNESS  (5.0)

#define EXTNAME_DATA  "DATA"
#define EXTNAME_DQ    "CONTRIB"
#define EXTNAME_ERROR "ERROR"
#define EXTNAME_DATA_COMMENT  "This extension contains data values"
#define EXTNAME_ERROR_COMMENT "This extension contains data errors"
#define EXTNAME_DQ_COMMENT    "This extension contains contribution values in seconds"

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include "hdrl.h"
#include <stdbool.h>
#include <eris_ifu_vector.h>
cpl_error_code eris_ifu_combine_jittered_images(
                            cpl_image     **imagesData,
                            cpl_image     **imagesError,
                            int           size_x,
                            int           size_y,
                            cpl_image     **mergedImageData,
                            cpl_image     **mergedImageError,
                            cpl_image     **mergedImageDIT,
                            int           n_cubes,
                            const float   *offsetx,
                            const float   *offsety,
                            const double  *exptimes,
                            const double  kappa,
                            const char    *compute_mode,
                            const int     pclip);

cpl_error_code eris_ifu_combine_divide_DIT(
                            cpl_imagelist **cubesData,
                            const int     n_cubes,
                            const double  *exptimes);

cpl_error_code eris_ifu_combine_auto_size_cube(
                            const float *offsetx,
                            const float *offsety,
                            const int   nframes,
                            float       *ref_offx,
                            float       *ref_offy,
                            int         *size_x,
                            int         *size_y);

cpl_error_code eris_ifu_combine_build_mask(
                            cpl_imagelist **cubesDataShifted,
                            cpl_image     *mergedImgDIT,
                            const int     n_cubes,
                            const int     *llx,
                            const int     *lly,
                            const double  *exptimes);

cpl_error_code eris_ifu_combine_build_mask_cube(
                            cpl_image     **imagesDataShifted,
                            cpl_image     **mergedCubeDIT_img,
                            const int     *llx,
                            const int     *lly,
                            const double  *exptimes,
                            int           n_cubes,
                            cpl_size      nx_out,
                            cpl_size      ny_out);

cpl_error_code eris_ifu_combine_coadd_ks_clip(
                            const int     n_cubes,
                            const double  kappa,
                            int           *llx,
                            int           *lly,
                            const double  *exptimes,
                            cpl_image **mergedCubeData_img,
                            cpl_image **mergedCubeError_img,
                            cpl_image *mergedCubeDIT_img,
                            cpl_image     **imagesDataShifted,
                            cpl_image     **imagesErrorShifted,
                            const char    *compute_mode,
                            const int     pclip, const int nx_out, const int ny_out);

cpl_error_code eris_ifu_combine_coadd_ks_clip_internal(cpl_image **cubesDataShifted,
                            const int       n_frames,
                            const int       n_contributions,
                            const int x, const int y,
                            int *llx, int *lly,
                            const double kappa,
                            cpl_vector   **msk,
                            const char   *compute_mode,
                            const int    pclip);

cpl_error_code eris_ifu_combine_coadd(const int       n_cubes, cpl_image **imgMergedCubeData,
                            cpl_image **imgMergedCubeError,
                            cpl_image *mergedImgDIT,
                            cpl_image       **cubesDataShifted,
                            cpl_image       **cubesErrorShifted,
                            const double    *exptimes,
                            int             *llx,
                            int             *lly,
                            const char      *compute_mode, const int nx_out, const int ny_out);

int eris_ifu_combine_calc_contributions(cpl_image **cubesDataShifted,
                            const int n_cubes,
                            const int *llx, const int *lly,
                            const int x, const int y);

cpl_error_code eris_ifu_combine_subtract_background(
                            cpl_image *img,
                            bool *warn);

void eris_ifu_combine_get_xy_min_max(
                            const int nframes,
                            const float *offsetx, const float *offsety,
                            float *min_offx, float *max_offx,
                            float *min_offy, float *max_offy);

int eris_ifu_combine_nearest_int(
                            const double x);

cpl_image* eris_ifu_combine_shift_image(
                            const cpl_image *img_in,
                            const double    shift_x,
                            const double    shift_y,
                            const double    *kernel);

void eris_ifu_combine_convert_0_to_NaN_img(
                            cpl_image *img);

double eris_ifu_combine_calc_error(
                            eris_ifu_vector *data_vec,
                            eris_ifu_vector *error_vec,
                            const char      *compute_mode);

cpl_error_code eris_ifu_combine_read_image_planes(
                            const cpl_frameset  *frameset,
                            cpl_image           **imagesData,
                            cpl_image           **imagesError,
                            int                 z,
                            int                 edge_trim,
                            bool                subtract_background);

int eris_ifu_combine_min_cube_size(const cpl_frameset *fs);

/* --- simple shifting from KMOS pipeline --- */

/** @brief The type of extrapolation behavior:
    - NONE_NANS: <br>
      no extrapolation will be done, points outside the input images will be
      set to NAN
    - NONE_CLIPPING <br>
      no extrapolation will be done, points outside the input images will be
      removed, the output image will be smaller
    - BCS_NATURAL: <br>
      only valid for the "BCS" interpolation, which will be of type natural,
      i.e. at the image edge the first derivate is assumed to be zero
    - BCS_ESTIMATED <br>
      only valid for the "BCS" interpolation, the second derivate at the
      image egde will be estimated by interpolation using the last three
      points.
    - RESIZE_NANS <br>
    - RESIZE_BCS_NATURAL <br>
    - RESIZE_BCS_ESTIMATED <br>
*/
enum extrapolationType {
    NONE_NANS,
    NONE_CLIPPING,
    BCS_NATURAL,
    BCS_ESTIMATED,
    RESIZE_NANS,
    RESIZE_BCS_NATURAL,
    RESIZE_BCS_ESTIMATED
};

cpl_image *eris_ifu_combine_shift_image_kmos(const cpl_image *img_in,
                                                 double xshift,
                                                 double yshift,
                                                 const char *method,
                                                 const enum extrapolationType extrapolation);

#endif 
