/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERIS_IFU_DFS_H
#define ERIS_IFU_DFS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

#include <stdbool.h>
#include "eris_ifu_constants.h"


/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/
#define UNIT_FLUXCAL "erg.s**(-1).cm**(-2).angstrom**(-1)"
#define UNIT_ADU "ADU"
#define UNIT_TIME "s"
#define UNITLESS ""
// Detector
#define ERIS_IFU_DETECTOR_SIZE              2048
#define ERIS_IFU_DETECTOR_SIZE_X            2048
#define ERIS_IFU_DETECTOR_SIZE_Y            2048
#define ERIS_IFU_DETECTOR_BP_BORDER         4

#define REC_NAME_DARK         "eris_ifu_dark"
#define REC_NAME_FLAT         "eris_ifu_flat"
#define REC_NAME_DISTORTION   "eris_ifu_distortion"
#define REC_NAME_DETLIN       "eris_ifu_detlin"
#define REC_NAME_WAVECAL      "eris_ifu_wavecal"
#define REC_NAME_STDSTAR      "eris_ifu_stdstar"
#define REC_NAME_PUPIL        "eris_ifu_pupil"
#define REC_NAME_JITTER       "eris_ifu_jitter"
#define REC_NAME_EXTRACT_SPEC "eris_ifu_extract_spec"
#define REC_NAME_COMBINE      "eris_ifu_combine"

/*-----------------------------------------------------------------------------
 * FITS header keywords
 ----------------------------------------------------------------------------*/
#define NAXIS1                          "NAXIS1"
#define CRPIX1                          "CRPIX1"
#define CRVAL1                          "CRVAL1"
#define CDELT1                          "CDELT1"
#define NAXIS2                          "NAXIS2"
#define CRPIX2                          "CRPIX2"
#define CRVAL2                          "CRVAL2"
#define CDELT2                          "CDELT2"
#define NAXIS3                          "NAXIS3"
#define CRPIX3                          "CRPIX3"
#define CRVAL3                          "CRVAL3"
#define CDELT3                          "CDELT3"
#define CUNIT3                          "CUNIT3"
#define CTYPE3                          "CTYPE3"
#define CD1_3                           "CD1_3"
#define CD2_3                           "CD2_3"
#define CD3_3                           "CD3_3"

// General
#define INSTRUMENT_ERIS                 "ERIS"
#define INSTRUMENT_SINFONI              "SINFONI"
#define INSTRUMENT_NONE                 "NONE"
#define ARM_NIX                         "NIX"
#define ARM_SPIFFIER                    "SPIFFIER"

#define FHDR_INSTRUMENT                 "INSTRUME"
#define FHDR_MJD_OBS                    "MJD-OBS"
//#define FHDR_DIT                        "ESO DET DIT"
#define FHDR_E_ARM                      "ESO SEQ ARM"
#define FHDR_EXPTIME                    "EXPTIME"
#define FHDR_DET_CHIP_GAIN              "ESO DET CHIP GAIN"
#define FHDR_DET_CHIP_RON               "ESO DET CHIP RON"
#define FHDR_DPR_TYPE                   "ESO DPR TYPE"
#define FHDR_DPR_TECH                   "ESO DPR TECH"
#define FHDR_PRO_CATG                   "ESO PRO CATG"
// ERIS/SPIFFIER
#define FHDR_E_DIT                      "ESO DET SEQ1 DIT"

#define FHDR_E_AR_LAMP_ST   "ESO INS1 LAMP3 ST"
#define FHDR_E_KR_LAMP_ST   "ESO INS1 LAMP4 ST"
#define FHDR_E_NE_LAMP_ST   "ESO INS1 LAMP5 ST"
#define FHDR_E_XE_LAMP_ST   "ESO INS1 LAMP6 ST"
#define FHDR_E_QTH_LAMP_ST  "ESO INS1 LAMP2 ST"
#define FHDR_E_FILTER_ID    "ESO INS3 SPFW ID"
#define FHDR_E_GRATING_ID   "ESO INS3 SPGW ID"
#define FHDR_E_PREOPTICS_ID "ESO INS3 SPXW ID"

#define E_GRATING_J_LOW    "J_low"
#define E_GRATING_H_LOW    "H_low"
#define E_GRATING_K_LOW    "K_low"
#define E_GRATING_J_SHORT  "J_short"
#define E_GRATING_J_MIDDLE "J_middle"
#define E_GRATING_J_LONG   "J_long"
#define E_GRATING_H_SHORT  "H_short"
#define E_GRATING_H_MIDDLE "H_middle"
#define E_GRATING_H_LONG   "H_long"
#define E_GRATING_K_SHORT  "K_short"
#define E_GRATING_K_MIDDLE "K_middle"
#define E_GRATING_K_LONG   "K_long"
#define E_PREOPTICS_250MAS_SCALE "250mas"
#define E_PREOPTICS_100MAS_SCALE "100mas"
#define E_PREOPTICS_25MAS_SCALE  "25mas"
#define E_PREOPTICS_PUPIL        "pupil"

#define FHDR_E_CRVAL1   "CRVAL1"
#define FHDR_E_CRVAL2   "CRVAL2"
#define FHDR_E_CUMOFFS1 "ESO OCS CUMOFFS RA"
#define FHDR_E_CUMOFFS2 "ESO OCS CUMOFFS DEC"


// SINFONI/SPIFFI
#define FHDR_S_DIT                      "ESO DET DIT"

#define FHDR_S_AR_LAMP_ST "ESO INS1 LAMP4 ST"
#define FHDR_S_KR_LAMP_ST "ESO INS1 LAMP2 ST"
#define FHDR_S_NE_LAMP_ST "ESO INS1 LAMP3 ST"
#define FHDR_S_XE_LAMP_ST "ESO INS1 LAMP1 ST"
#define FHDR_S_NA_LAMP_ST "ESO INS1 LAMP6 ST"
#define FHDR_S_QTH_LAMP_ST "ESO INS1 LAMP5 ST"
#define FHDR_S_FILTER_ID   "ESO INS FILT1 ID"
#define FHDR_S_FILTER_NAME "ESO INS FILT1 NAME"
#define FHDR_S_GRATING_ID  "ESO INS GRAT1 ID"
#define FHDR_S_PREOPTICS_ID "ESO INS OPTI1 NAME"

#define S_GRATING_J_BAND "J"
#define S_GRATING_H_BAND "H"
#define S_GRATING_K_BAND "K"
#define S_GRATING_HK_BAND "H+K"
#define S_PREOPTICS_250MAS_SCALE "0.25"
#define S_PREOPTICS_100MAS_SCALE "0.1"
#define S_PREOPTICS_25MAS_SCALE "0.025"
#define S_PREOPTICS_PUPIL        "pupil"


/*----------------------------------------------------------------------------
 * Raw frame types for ERIS/SPIFFIER
 *         don't forget to update the ERIS_IFU_RAW_TAGS macro when frame types
 *         are added or removed
 *--------------------------------------------------------------------------*/

#define ERIS_IFU_RAW_DARK                    "DARK"
#define ERIS_IFU_RAW_FIBRE_NS               "FIBRE_NS"
#define ERIS_IFU_RAW_FLAT_LAMP              "FLAT_LAMP"
#define ERIS_IFU_RAW_FLAT_LAMP_ON           "FLAT_LAMP_ON"
#define ERIS_IFU_RAW_FLAT_LAMP_OFF          "FLAT_LAMP_OFF"
#define ERIS_IFU_RAW_FLAT_NS                "FLAT_NS"
#define ERIS_IFU_RAW_FLAT_NS_ON             "FLAT_NS_ON"
#define ERIS_IFU_RAW_FLAT_NS_OFF            "FLAT_NS_OFF"
#define ERIS_IFU_RAW_WAVE_NS                "WAVE_NS"
#define ERIS_IFU_RAW_WAVE_NS_ON             "WAVE_NS_ON"
#define ERIS_IFU_RAW_WAVE_NS_OFF            "WAVE_NS_OFF"
#define ERIS_IFU_RAW_ARC_LAMP               "WAVE_LAMP"
#define ERIS_IFU_RAW_ARC_LAMP_ON            "WAVE_LAMP_ON"
#define ERIS_IFU_RAW_ARC_LAMP_OFF           "WAVE_LAMP_OFF"
#define ERIS_IFU_RAW_SKY                    "SKY"
#define ERIS_IFU_RAW_DARK_NS                "DARK_NS"
#define ERIS_IFU_RAW_FIBRE_NS               "FIBRE_NS"
#define ERIS_IFU_RAW_OBJ                    "OBJ"
#define ERIS_IFU_RAW_SKY                    "SKY"
#define ERIS_IFU_RAW_OBJ_SKY                "SKY_OBJ"
#define ERIS_IFU_RAW_STD_FLUX               "STD_FLUX"
#define ERIS_IFU_RAW_STD_FLUX_SKY           "SKY_STD_FLUX"
#define ERIS_IFU_RAW_STD                    "STD"
#define ERIS_IFU_RAW_STD_SKY                "SKY_STD"
#define ERIS_IFU_RAW_PSF                    "PSF_CALIBRATOR"
#define ERIS_IFU_RAW_PSF_SKY                "SKY_PSF_CALIBRATOR"
#define ERIS_IFU_RAW_PUPIL_LAMP             "PUPIL_LAMP"
#define ERIS_IFU_RAW_PUPIL_SKY              "PUPIL_SKY"
#define ERIS_IFU_RAW_LIN                    "LINEARITY_LAMP"
#define ERIS_PERSISTENCE_IMA                "PERSISTENCE_IMA"
#define ERIS_PERSISTENCE_CUBE               "PERSISTENCE_CUBE"


//#define ERIS_IFU_KEY_NAME_LAMP_HALO         FHDR_E_QTH_LAMP_ST

#define ERIS_IFU_RAW_TAGS "," \
        ERIS_IFU_RAW_DARK "," \
        ERIS_IFU_RAW_FLAT_LAMP_ON "," \
		ERIS_IFU_RAW_FLAT_LAMP_OFF "," \
		ERIS_IFU_RAW_FLAT_LAMP "," \
        ERIS_IFU_RAW_FLAT_NS "," \
		ERIS_IFU_RAW_FLAT_NS_ON "," \
	    ERIS_IFU_RAW_FLAT_NS_OFF "," \
        ERIS_IFU_RAW_WAVE_NS "," \
		ERIS_IFU_RAW_WAVE_NS_ON "," \
		ERIS_IFU_RAW_WAVE_NS_OFF "," \
        ERIS_IFU_RAW_ARC_LAMP "," \
		ERIS_IFU_RAW_ARC_LAMP_ON "," \
		ERIS_IFU_RAW_ARC_LAMP_OFF "," \
        ERIS_IFU_RAW_DARK_NS "," \
        ERIS_IFU_RAW_FIBRE_NS "," \
        ERIS_IFU_RAW_OBJ "," \
        ERIS_IFU_RAW_SKY "," \
        ERIS_IFU_RAW_OBJ_SKY "," \
        ERIS_IFU_RAW_STD "," \
        ERIS_IFU_RAW_STD_SKY "," \
	ERIS_IFU_RAW_PUPIL_LAMP "," \
        ERIS_IFU_RAW_PUPIL_SKY "," \
		ERIS_IFU_RAW_STD_FLUX "," \
        ERIS_IFU_RAW_STD_FLUX_SKY "," \
        ERIS_IFU_RAW_PSF "," \
        ERIS_IFU_RAW_PSF_SKY "," \
        ERIS_PERSISTENCE_IMA "," \
        ERIS_PERSISTENCE_CUBE "," \
        ERIS_IFU_RAW_LIN ","

/*----------------------------------------------------------------------------
 * Calibration frame types for ERIS/SPIFFIER
 *      don't forget to update the ERIS_IFU_REF_CALIB_TAGS macro when frame types
 *      are added or removed
 *--------------------------------------------------------------------------*/
#define ERIS_IFU_CALIB_DARK                 "MASTER_DARK"
#define ERIS_IFU_CALIB_FLATFIELD            "MASTER_FLAT"
#define ERIS_IFU_CALIB_DISTORTION            "DISTORTION"
#define ERIS_IFU_CALIB_REF_LINES            "REF_LINE_ARC"
#define ERIS_IFU_CALIB_FIRST_FIT            "FIRST_WAVE_FIT"
#define ERIS_IFU_CALIB_WAVE_SETUP           "WAVE_SETUP"
#define ERIS_IFU_CALIB_SLIT_POS                 "SLITLET_POS"
#define ERIS_IFU_CALIB_DIST_SETUP_WAVE      "DRS_SETUP_WAVE"
#define ERIS_IFU_CALIB_WAVE_MAP             "WAVE_MAP"
#define ERIS_IFU_CALIB_DISTANCES            "DISTANCES"
#define ERIS_IFU_CALIB_DARK_BP_MAP          "BPM_DARK"
#define ERIS_IFU_CALIB_DETLIN_BP_MAP        "BPM_LINEARITY"
#define ERIS_IFU_CALIB_OH_SPEC              "OH_SPEC"
#define ERIS_IFU_CALIB_TELL_MOD_CATALOG     "TELL_MOD_CATALOG"
#define ERIS_IFU_CALIB_EXTCOEFF_TABLE       "EXTCOEFF_TABLE"
#define ERIS_IFU_CALIB_FLUX_STD_CATALOG     "FLUX_STD_CATALOG"
#define ERIS_IFU_CALIB_EFFICIENCY_WINDOWS   "EFFICIENCY_WINDOWS"
#define ERIS_IFU_CALIB_RESPONSE_WINDOWS     "RESPONSE_WINDOWS"
#define ERIS_IFU_CALIB_FIT_AREAS            "FIT_AREAS"
#define ERIS_IFU_CALIB_QUALITY_AREAS        "QUALITY_AREAS"
#define ERIS_IFU_CALIB_ATMOS_EXT            "ATMOS_EXT"
#define ERIS_IFU_CALIB_HIGH_ABS_REGIONS     "HIGH_ABS_REGIONS"
#define ERIS_IFU_CALIB_RESP_FIT_POINTS_CATALOG     "RESP_FIT_POINTS_CATALOG"
#define ERIS_IFU_CALIB_TELL_MOD_CATALOG     "TELL_MOD_CATALOG"
#define ERIS_PERSISTENCE_DBG                "PERSISTENCE_DBG"
#define ERIS_PERSISTENCE_DBG_FN             "eris_persistence_dbg.fits"
#define ERIS_PERSISTENCE_HDR                "PERSISTENCE_HDR"
#define ERIS_PERSISTENCE_HDR_FN             "eris_persistence_hdr.fits"
#define ERIS_RESAMPLE_TABLE                 "RESAMPLE_TABLE"

#define ERIS_IFU_REF_CALIB_TAGS "," \
        ERIS_IFU_CALIB_DARK "," \
        ERIS_IFU_CALIB_FLATFIELD "," \
        ERIS_IFU_CALIB_DISTORTION "," \
        ERIS_IFU_CALIB_REF_LINES "," \
        ERIS_IFU_CALIB_FIRST_FIT "," \
        ERIS_IFU_CALIB_WAVE_SETUP "," \
        ERIS_IFU_CALIB_SLIT_POS "," \
        ERIS_IFU_CALIB_DIST_SETUP_WAVE "," \
        ERIS_IFU_CALIB_WAVE_MAP "," \
        ERIS_IFU_CALIB_DISTANCES "," \
        ERIS_IFU_CALIB_DARK_BP_MAP "," \
        ERIS_IFU_CALIB_DETLIN_BP_MAP "," \
        ERIS_IFU_CALIB_EXTCOEFF_TABLE "," \
        ERIS_IFU_CALIB_FLUX_STD_CATALOG "," \
        ERIS_IFU_CALIB_EFFICIENCY_WINDOWS "," \
        ERIS_IFU_CALIB_RESPONSE_WINDOWS "," \
        ERIS_IFU_CALIB_FIT_AREAS "," \
        ERIS_IFU_CALIB_QUALITY_AREAS "," \
        ERIS_IFU_CALIB_ATMOS_EXT "," \
        ERIS_IFU_CALIB_HIGH_ABS_REGIONS "," \
        ERIS_IFU_CALIB_RESP_FIT_POINTS_CATALOG "," \
        ERIS_IFU_CALIB_TELL_MOD_CATALOG "," \
        ERIS_RESAMPLE_TABLE "," \
        ERIS_IFU_CALIB_OH_SPEC ","

/*----------------------------------------------------------------------------
 * Frame types for utilities
 *   don't forget to update the ERIS_IFU_REF_CALIB_TAGS macro when frame types
 *   are added or removed
 *--------------------------------------------------------------------------*/
#define ERIS_IFU_UTIL_CUBE              "CUBE"
#define ERIS_IFU_UTIL_MASK              "MASK"

#define ERIS_IFU_REF_UTIL_TAGS "," \
        ERIS_IFU_UTIL_CUBE "," \
        ERIS_IFU_UTIL_MASK ","

/*----------------------------------------------------------------------------
 * DO CATG
 *--------------------------------------------------------------------------*/
/* IDPs */
#define PRODCATG_CUBE_OBJ "ANCILLARY.CUBE.IFS"
#define PRODCATG_CUBE_SKY "ANCILLARY.CUBE.IFS.SKY"

#define ERIS_IFU_COMBINE_DOCATG "OBJECT_CUBE"
#define ERIS_IFU_COMBINE_PROCATG "COMBINED_CUBE"

/*----------------------------------------------------------------------------
 * Product frame types for ERIS/SPIFFIER which are (also) used as calibrations
 *      don't forget to update the ERIS_IFU_PRO_CALIB_TAGS macro when frame types
 *      are added or removed
 *--------------------------------------------------------------------------*/

/* eris_ifu_dark */
/* product_level: 0 */
#define ERIS_IFU_PRO_DARK                    "MASTER_DARK_IFU"
#define ERIS_IFU_PRO_DARK_FN                "eris_ifu_dark_master_dark.fits"
#define ERIS_IFU_PRO_DARK_BPM                "BPM_DARK"
#define ERIS_IFU_PRO_DARK_BPM_FN            "eris_ifu_dark_bpm.fits"
/* product_level: 1 */
#define ERIS_IFU_PRO_DARK_DBG_BPM2D            "DARK_BPM2D"
#define ERIS_IFU_PRO_DARK_DBG_BPM2D_FN        "eris_ifu_dark_bpm2d.fits"
#define ERIS_IFU_PRO_DARK_DBG_BPM3D            "DARK_BPM3D"
#define ERIS_IFU_PRO_DARK_DBG_BPM3D_FN        "eris_ifu_dark_bpm3d.fits"
#define ERIS_IFU_PRO_DARK_DBG_CONTRIBMAP    "DARK_CONTRIBMAP"
#define ERIS_IFU_PRO_DARK_DBG_CONTRIBMAP_FN    "eris_ifu_dark_contribMap.fits"
/* product_level: 2 */
#define ERIS_IFU_PRO_DARK_DBG_IMAGE_FN      "eris_ifu_dark_dbg_image"
#define ERIS_IFU_PRO_DARK_DBG_CUBE_FN        "eris_ifu_dark_dbg_cube"
#define ERIS_IFU_PRO_DARK_DBG_3D_FN        "eris_ifu_dark_dbg_3d"

/* eris_ifu_flat */
/* product_level: 0 */
#define ERIS_IFU_PRO_FLAT                    "MASTER_FLAT"
#define ERIS_IFU_PRO_FLAT_FN                "eris_ifu_flat_master_flat.fits"
#define ERIS_IFU_PRO_FLAT_BPM                "BPM_FLAT"
#define ERIS_IFU_PRO_FLAT_BPM_FN            "eris_ifu_flat_bpm.fits"
/* product_level: 1 */
#define ERIS_IFU_PRO_FLAT_DBG_HI            "_DBG_LAMP_HI"
#define ERIS_IFU_PRO_FLAT_DBG_HI_FN         "_dbg_flat_hi.fits"
#define ERIS_IFU_PRO_FLAT_DBG_BPM2D            "_DBG_BPM2D"
#define ERIS_IFU_PRO_FLAT_DBG_BPM2D_FN      "_dbg_bpm2d.fits"
#define ERIS_IFU_PRO_FLAT_DBG_BPM3D            "_DBG_BPM3D"
#define ERIS_IFU_PRO_FLAT_DBG_BPM3D_FN      "_dbg_bpm3d.fits"
#define ERIS_IFU_PRO_FLAT_DBG_CONTRIBMAP    "_DBG_CONTRIBMAP"
#define ERIS_IFU_PRO_FLAT_DBG_CONTRIBMAP_FN "_dbg_flat_contribMap.fits"
/* product_level: 2 */
#define ERIS_IFU_PRO_FLAT_DBG_CUBE            "FLAT_DBG_CUBE"
#define ERIS_IFU_PRO_FLAT_DBG_CUBE_FN        "_dbg_flat_cube"
#define ERIS_IFU_PRO_FLAT_DBG_CUBE_ON_FN    "_dbg_flat_on"
#define ERIS_IFU_PRO_FLAT_DBG_CUBE_OFF_FN   "_dbg_flat_off"

/* eris_ifu_wavecal */
/* product_level: 0 */
#define ERIS_IFU_PRO_WAVE_MAP               "WAVE_MAP"
#define ERIS_IFU_PRO_WAVE_MAP_FN            "eris_ifu_wave_map.fits"
/* product_level: 1 */
#define ERIS_IFU_PRO_WAVE_LAMP_STACKED      "WAVE_LAMP_STACKED"
#define ERIS_IFU_PRO_WAVE_LAMP_STACKED_FN   "eris_ifu_wave_arcImg_stacked.fits"
#define ERIS_IFU_PRO_WAVE_LAMP_RESAMPLED    "WAVE_LAMP_RESAMPLED"
#define ERIS_IFU_PRO_WAVE_LAMP_RESAMPLED_FN "eris_ifu_wave_arcImg_resampled.fits"
#define ERIS_IFU_PRO_WAVE_COLLAP_SPECTR     "WAVE_COLLAPSED_SPECTR"
#define ERIS_IFU_PRO_WAVE_COLLAP_SPECTR_FN  "eris_ifu_wave_dbg_collapSpect.fits"
#define ERIS_IFU_PRO_WAVE_FIT_TABLES        "WAVE_FIT_TABLES"
#define ERIS_IFU_PRO_WAVE_FIT_TABLES_FN     "eris_ifu_wave_dbg_fit_tables.fits"

/* eris_ifu_distortion */
/* product_level: 0 */
//#define ERIS_IFU_PRO_DIST_DISTANCES                 "DISTANCES"
//#define ERIS_IFU_PRO_DIST_DISTANCES_FN              "eris_ifu_distortion_distances.fits"
#define ERIS_IFU_PRO_DIST_SLIT_POS                  "SLITLET_POS"
#define ERIS_IFU_PRO_DIST_SLIT_POS_FN               "eris_ifu_distortion_slitlet_pos.fits"
#define ERIS_IFU_PRO_DIST_DISTORTION                "DISTORTION"
#define ERIS_IFU_PRO_DIST_DISTORTION_FN             "eris_ifu_distortion_distortion.fits"
#define ERIS_IFU_PRO_DIST_BPM                       "BPM_DIST"
#define ERIS_IFU_PRO_DIST_BPM_FN                    "eris_ifu_distortion_bpm.fits"
/* product_level: 1 */
//#define ERIS_IFU_PRO_DIST_DBG_STACKED_ON            "DIST_DBG_STACKED_ON"
#define ERIS_IFU_PRO_DIST_DBG_STACKED_ON_FN         "eris_ifu_distortion_dbg_ns_on"
//#define ERIS_IFU_PRO_DIST_DBG_STACKED_OFF           "DIST_DBG_STACKED_OFF"
//#define ERIS_IFU_PRO_DIST_DBG_STACKED_OFF_FN        "eris_ifu_distortion_dbg_ns_off.fits"
//#define ERIS_IFU_PRO_DIST_DBG_STACKED               "DIST_DBG_STACKED"
#define ERIS_IFU_PRO_DIST_DBG_STACKED_FN            "eris_ifu_distortion_dbg_ns_div"
//#define ERIS_IFU_PRO_DIST_DBG_DARK                  "DIST_DBG_DARK"
#define ERIS_IFU_PRO_DIST_DBG_DARK_FN               "eris_ifu_distortion_dbg_dark"
#define ERIS_IFU_PRO_DIST_DBG_WARPED                "DIST_DBG_WARPED"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_FIT            "DIST_DBG_WARPED_FIT"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_FN             "eris_ifu_distortion_dbg_ns_warped.fits"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_CUBE_FN        "eris_ifu_distortion_dbg_ns_warped_cube.fits"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_CUBE_FLAT      "DIST_DBG_WARPED_CUBE_FLAT"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_CUBE_FLAT_FN   "eris_ifu_distortion_dbg_ns_warped_cube_flat.fits"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_CUBE_FLAT_MEAN      "DIST_DBG_WARPED_CUBE_FLAT_MEAN"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_CUBE_FLAT_MEAN_FN   "eris_ifu_distortion_dbg_ns_warped_cube_flat_mean.fits"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_WAVE           "DIST_DBG_WARPED_WAVE"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_WAVE_FN        "eris_ifu_distortion_dbg_ns_warped_wave.fits"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_FULL           "DIST_DBG_WARPED_FULL"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_FULL_FN        "eris_ifu_distortion_dbg_ns_warped_full.fits"
#define ERIS_IFU_PRO_DIST_DBG_WARPED_CUBE_FULL_FN   "eris_ifu_distortion_dbg_ns_warped_cube_full.fits"
#define ERIS_IFU_PRO_DIST_DBG_MASTER_FLAT_LAMP      "DIST_DBG_MASTER_FLAT_LAMP"
#define ERIS_IFU_PRO_DIST_DBG_MASTER_FLAT_LAMP_FN   "eris_ifu_distortion_dbg_flat_lamp.fits"

/* product_level: 2 */
#define ERIS_IFU_PRO_DIST_QC_FIT_FN                "eris_ifu_distortion_qc_fit.fits"
#define ERIS_IFU_PRO_DIST_QC_WARPED_FIT_FN         "eris_ifu_distortion_qc_warped_fit.fits"
/* product_level: 3 */
#define ERIS_IFU_PRO_DIST_DBG_DIST_FIT_GRID      "DIST_DBG_WARPED_VAL2FIT"
#define ERIS_IFU_PRO_DIST_DBG_DIST_FIT_GRID_FN   "eris_ifu_distortion_grid_val2fit.fits"
/* product_level: 4 */

/* eris_ifu_detlin */
/* product_level: 0 */
#define ERIS_IFU_PRO_DETLIN_BPM                     "BPM_DETLIN"
#define ERIS_IFU_PRO_DETLIN_BPM_FN                  "eris_ifu_detlin_bpm.fits"
#define ERIS_IFU_PRO_DETLIN_BPM_FILT                "BPM_DETLIN_FILT"
#define ERIS_IFU_PRO_DETLIN_BPM_FILT_FN             "eris_ifu_detlin_bpm_filt.fits"
#define ERIS_IFU_PRO_DETLIN_GAIN_INFO               "GAIN_INFO"
#define ERIS_IFU_PRO_DETLIN_GAIN_INFO_FN            "eris_ifu_detlin_gain_info.fits"

//product_level: 2
#define ERIS_IFU_PRO_DETLIN_DBG_CUBE_ON_FN          "eris_ifu_detlin_dbg_cubeOn"
#define ERIS_IFU_PRO_DETLIN_DBG_CUBE_OFF_FN         "eris_ifu_detlin_dbg_cubeOff"
#define ERIS_IFU_PRO_DETLIN_DBG_CUBE_SUB_FN         "eris_ifu_detlin_dbg_cubeSub"

/* eris_ifu_jitter */
/* product_level: 0 */
#define ERIS_IFU_PRO_JITTER_CUBE_COMBINE            "CUBE_COMBINE"
#define ERIS_IFU_PRO_JITTER_CUBE_COMBINE_FN  "eris_ifu_jitter_cube_combine.fits"
#define ERIS_IFU_PRO_JITTER_CUBE_MEAN               "CUBE_MEAN"
#define ERIS_IFU_PRO_JITTER_CUBE_MEAN_FN            "cube_mean.fits"
#define ERIS_IFU_PRO_JITTER_CUBE                    "CUBE"
#define ERIS_IFU_PRO_JITTER_TWK_CUBE_COADD_FLUXCAL  "SKY_TWEAKED_CUBE_COADD_FLUXCAL"
#define ERIS_IFU_PRO_JITTER_TWK_CUBE_COADD          "SKY_TWEAKED_CUBE_COADD"
#define ERIS_IFU_PRO_JITTER_TWK_CUBE_COADD_FN       "eris_ifu_jitter_twk_cube_coadd"
#define ERIS_IFU_PRO_JITTER_TWK_CUBE_MEAN           "SKY_TWEAKED_CUBE_MEAN"
#define ERIS_IFU_PRO_JITTER_DAR_CUBE_COADD_FLUXCAL  "DAR_CORRECTED_CUBE_COADD_FLUXCAL"
#define ERIS_IFU_PRO_JITTER_DAR_CUBE_COADD          "DAR_CORRECTED_CUBE_COADD"
#define ERIS_IFU_PRO_JITTER_DAR_CUBE_COADD_FN       "eris_ifu_jitter_dar_cube_coadd"
#define ERIS_IFU_PRO_JITTER_OBJ_DAR_CUBE_COADD      "DAR_CORRECTED_CUBE_COADD"
#define ERIS_IFU_PRO_JITTER_OBJ_DAR_CUBE_COADD_FLUXCAL      "DAR_CORRECTED_CUBE_COADD_FLUXCAL"
#define ERIS_IFU_PRO_JITTER_OBJ_DAR_CUBE_MEAN       "DAR_CORRECTED_CUBE_MEAN"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD_FLUXCAL_MEAN "OBJECT_CUBE_COADD_FLUXCAL_MEAN"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_FLUXCAL_MEAN "STD_CUBE_COADD_FLUXCAL_MEAN"
#define ERIS_IFU_PRO_JITTER_FLUX_STD_CUBE_COADD_FLUXCAL_MEAN "FLUX_STD_CUBE_COADD_FLUXCAL_MEAN"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD_FLUXCAL_MEAN "STD_FLUX_CUBE_COADD_FLUXCAL_MEAN"
#define ERIS_IFU_PRO_JITTER_OBJ_DAR_CUBE_MEDIAN     "DAR_CORRECTED_CUBE_MEDIAN"

#define ERIS_IFU_PRO_JITTER_TWK_OBJ_CUBE_COADD_FLUXCAL_MEAN "SKY_TWEAKED_CUBE_COADD_FLUXCAL_MEAN"

#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD          "OBJECT_CUBE_COADD"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD_FLUXCAL  "OBJECT_CUBE_COADD_FLUXCAL"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_MEAN_FLUXCAL   "OBJECT_CUBE_MEAN_FLUXCAL"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_COADD          "STD_CUBE_COADD"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_FLUXCAL  "STD_CUBE_COADD_FLUXCAL"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD      "STD_FLUX_CUBE_COADD"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD_FLUXCAL "STD_FLUX_CUBE_COADD_FLUXCAL"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_NOFLAT   "STD_CUBE_COADD_NOFLAT"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD_NOFLAT   "STD_FLUX_CUBE_COADD_NOFLAT"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE_COADD          "PSF_CUBE_COADD"
#define ERIS_IFU_PRO_JITTER_PUPIL_CUBE_COADD        "PUPIL_CUBE_COADD"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE_COADD_FLUXCAL  "PSF_CUBE_COADD_FLUXCAL"
#define ERIS_IFU_PRO_JITTER_SKY_CUBE_COADD          "SKY_CUBE_COADD"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD_FN       "eris_ifu_jitter_obj_cube_coadd"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_FN        "std_cube_coadd"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD_FN  "std_flux_cube_coadd"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_NOFLAT_FN "std_cube_coadd_no_flat"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD_NOFLAT_FN "std_flux_cube_coadd_no_flat"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE_COADD_FN       "psf_cube_coadd"
#define ERIS_IFU_PRO_JITTER_PUPIL_CUBE_COADD_FN     "pupil_cube_coadd"
#define ERIS_IFU_PRO_JITTER_CUBE_MEAN               "CUBE_MEAN"

//#define ERIS_IFU_PRO_JITTER_EXPOSURE_MAP            "OBJECT_EXPOSURE_MAP"
#define ERIS_IFU_PRO_JITTER_EXPOSURE_MAP            "EXPOSURE_MAP"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_MEAN           "OBJECT_CUBE_MEAN"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_NOFLAT_MEAN    "OBJECT_CUBE_NOFLAT_MEAN"
#define ERIS_IFU_PRO_JITTER_OBJ_DAR_CUBE_FLUXCAL_MEAN "DAR_CORRECTED_CUBE_COADD_FLUXCAL_MEAN"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_MEAN           "STD_CUBE_MEAN"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_NOFLAT_MEAN    "STD_CUBE_NOFLAT_MEAN"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_MEAN      "STD_FLUX_CUBE_MEAN"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE_MEAN           "PSF_CUBE_MEAN"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE_NOFLAT_MEAN    "PSF_CUBE_NOFLAT_MEAN"
#define ERIS_IFU_PRO_JITTER_SKY_CUBE_MEAN           "SKY_CUBE_MEAN"
#define ERIS_IFU_PRO_JITTER_SKY_CUBE_NOFLAT_MEAN    "SKY_CUBE_NOFLAT_MEAN"
#define ERIS_IFU_PRO_JITTER_CUBE_MEDIAN             "CUBE_MEDIAN"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_MEDIAN         "OBJECT_CUBE_MEDIAN"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_MEDIAN         "STD_CUBE_MEDIAN"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_MEDIAN    "STD_FLUX_CUBE_MEDIAN"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE_MEDIAN         "PSF_CUBE_MEDIAN"
#define ERIS_IFU_PRO_JITTER_SKY_CUBE_MEDIAN         "SKY_CUBE_MEDIAN"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE_COADD_MEDIAN    "PSF_CUBE_COADD_MEDIAN"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_MEDIAN    "STD_CUBE_COADD_MEDIAN"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD_MEDIAN    "STD_FLUX_CUBE_COADD_MEDIAN"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD_MEDIAN    "OBJECT_CUBE_COADD_MEDIAN"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE_COADD_MEAN      "PSF_CUBE_COADD_MEAN"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_MEAN      "STD_CUBE_COADD_MEAN"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD_MEAN      "OBJECT_CUBE_COADD_MEAN"
#define ERIS_IFU_PRO_JITTER_CUBE_MEDIAN_FN          "eris_ifu_jitter_cube_median"
#define ERIS_IFU_PRO_JITTER_CUBE_FN                 "eris_ifu_jitter_cube"
#define ERIS_IFU_PRO_JITTER_CUBE_FLUXCAL_FN         "eris_ifu_jitter_cube_fluxcal"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE                "PSF_CUBE"
#define ERIS_IFU_PRO_JITTER_PSF_CUBE_FN             "psf_cube"
#define ERIS_IFU_PRO_JITTER_STD_CUBE                "STD_CUBE"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_NOFLAT         "STD_CUBE_NOFLAT"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE           "STD_FLUX_CUBE"
#define ERIS_IFU_PRO_JITTER_PUPIL_CUBE              "PUPIL_CUBE"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_NOFLAT    "STD_FLUX_CUBE_NOFLAT"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_NOFLAT_FN      "std_cube_no_flat"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_FN        "std_flux_cube"
#define ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_NOFLAT_FN "std_flux_cube_no_flat"
#define ERIS_IFU_PRO_JITTER_STD_CUBE_FN             "std_cube"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE                "OBJECT_CUBE"
#define ERIS_IFU_PRO_JITTER_OBJ_CUBE_FN             "obj_cube"
#define ERIS_IFU_PRO_JITTER_SKY_CUBE                "SKY_CUBE"
#define ERIS_IFU_PRO_JITTER_SKY_STD_FLUX_CUBE       "SKY_STD_FLUX_CUBE"
#define ERIS_IFU_PRO_JITTER_SKY_CUBE_FN             "sky_cube"
#define ERIS_IFU_PRO_JITTER_TWK_CUBE                "SKY_TWEAKED_CUBE"
#define ERIS_IFU_PRO_JITTER_TWK_CUBE_FN             "twk_cube"
#define ERIS_IFU_PRO_JITTER_DAR_CUBE                "DAR_CORRECTED_CUBE"
#define ERIS_IFU_PRO_JITTER_DAR_CUBE_FN             "dar_cube"
#define ERIS_IFU_PRO_JITTER_BPM_CUBE                "BPM_CUBE"
#define ERIS_IFU_PRO_JITTER_BPM_CUBE_FN             "bpm_cube"
//product_level: 1
//product level: 3
#define ERIS_IFU_PRO_JITTER_DBG_RAW_FN              "eris_ifu_jitter_dbg_raw"
#define ERIS_IFU_PRO_JITTER_DBG_DARK_FN             "eris_ifu_jitter_dbg_darksub"
#define ERIS_IFU_PRO_JITTER_DBG_FLAT_FN             "eris_ifu_jitter_dbg_flat"
#define ERIS_IFU_PRO_JITTER_DBG_WRAP_FN             "eris_ifu_jitter_dbg_wrap"
#define ERIS_IFU_PRO_JITTER_DBG_WAVE_FN             "eris_ifu_jitter_dbg_wave"
#define ERIS_IFU_PRO_JITTER_SPECTRUM                "SPECTRUM"
#define ERIS_IFU_PRO_JITTER_SPECTRUM_NOFLAT         "SPECTRUM_NOFLAT"
#define ERIS_IFU_PRO_JITTER_SPECTRUM_FLUXCAL        "SPECTRUM_FLUXCAL"
#define ERIS_IFU_PRO_JITTER_SPECTRUM_FLUXCAL_FN     "eris_ifu_jitter_spectrum_fluxcal"
#define ERIS_IFU_PRO_JITTER_EXTRACTION_MASK         "EXTRACTION_MASK"
#define ERIS_IFU_PRO_JITTER_EXTRACTION_MASK_FN      "eris_ifu_jitter_extraction_mask"
#define ERIS_IFU_PRO_JITTER_EFFICIENCY              "EFFICIENCY"
#define ERIS_IFU_PRO_JITTER_EFFICIENCY_FN           "eris_ifu_jitter_efficiency"
#define ERIS_IFU_PRO_JITTER_RESPONSE                "RESPONSE"
#define ERIS_IFU_PRO_JITTER_RESPONSE_FN             "eris_ifu_jitter_response"

#define ERIS_IFU_PRO_COMBINE                        "COMBINED_CUBE"

#define ERIS_IFU_PRO_CALIB_TAGS "," \
        ERIS_IFU_PRO_DARK "," \
        "MASTER_DARK_IMG" "," \
        ERIS_IFU_PRO_DARK_BPM "," \
        ERIS_IFU_PRO_FLAT "," \
        ERIS_IFU_PRO_FLAT_BPM "," \
        ERIS_IFU_PRO_WAVE_MAP "," \
        ERIS_IFU_PRO_DIST_DISTORTION "," \
        ERIS_IFU_PRO_DIST_BPM "," \
        ERIS_IFU_PRO_DETLIN_BPM "," \
        ERIS_IFU_PRO_JITTER_RESPONSE "," \
        ERIS_IFU_PRO_DETLIN_BPM_FILT ","

#define ERIS_IFU_PRO_JITTER_TAGS "," \
        ERIS_IFU_PRO_JITTER_OBJ_CUBE "," \
        ERIS_IFU_PRO_JITTER_STD_CUBE "," \
		ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE "," \
        ERIS_IFU_PRO_JITTER_STD_CUBE_NOFLAT "," \
		ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_NOFLAT "," \
        ERIS_IFU_PRO_JITTER_PSF_CUBE "," \
        ERIS_IFU_PRO_JITTER_SKY_CUBE "," \
        ERIS_IFU_PRO_JITTER_TWK_CUBE_COADD "," \
        ERIS_IFU_PRO_JITTER_TWK_CUBE_MEAN "," \
        ERIS_IFU_PRO_JITTER_SKY_STD_FLUX_CUBE "," \
		ERIS_IFU_PRO_JITTER_TWK_CUBE "," \
        ERIS_IFU_PRO_JITTER_BPM_CUBE "," \
        ERIS_IFU_PRO_JITTER_DAR_CUBE "," \
		ERIS_IFU_PRO_JITTER_OBJ_DAR_CUBE_COADD "," \
		ERIS_IFU_PRO_JITTER_OBJ_DAR_CUBE_COADD_FLUXCAL "," \
		ERIS_IFU_PRO_JITTER_OBJ_DAR_CUBE_MEAN "," \
		ERIS_IFU_PRO_JITTER_OBJ_DAR_CUBE_MEDIAN "," \
        ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD "," \
		ERIS_IFU_PRO_JITTER_DAR_CUBE_COADD "," \
		ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD_FLUXCAL "," \
        ERIS_IFU_PRO_JITTER_STD_CUBE_COADD "," \
		ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_FLUXCAL "," \
		ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD "," \
        ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_NOFLAT "," \
		ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD_FLUXCAL "," \
		ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD_NOFLAT "," \
        ERIS_IFU_PRO_JITTER_PSF_CUBE_COADD "," \
        ERIS_IFU_PRO_JITTER_PSF_CUBE_COADD_FLUXCAL "," \
        ERIS_IFU_PRO_JITTER_SKY_CUBE_COADD "," \
        ERIS_IFU_PRO_JITTER_OBJ_CUBE_MEAN "," \
        ERIS_IFU_PRO_JITTER_STD_CUBE_MEAN "," \
		ERIS_IFU_PRO_JITTER_OBJ_CUBE_NOFLAT_MEAN "," \
		ERIS_IFU_PRO_JITTER_STD_CUBE_NOFLAT_MEAN "," \
		ERIS_IFU_PRO_JITTER_PSF_CUBE_NOFLAT_MEAN "," \
		ERIS_IFU_PRO_JITTER_SKY_CUBE_NOFLAT_MEAN "," \
		ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_MEAN "," \
        ERIS_IFU_PRO_JITTER_PSF_CUBE_MEAN "," \
        ERIS_IFU_PRO_JITTER_STD_CUBE_MEDIAN "," \
		ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_MEDIAN "," \
        ERIS_IFU_PRO_JITTER_PSF_CUBE_MEDIAN "," \
        ERIS_IFU_PRO_JITTER_SKY_CUBE_MEAN "," \
        ERIS_IFU_PRO_JITTER_SKY_CUBE_MEDIAN "," \
		ERIS_IFU_PRO_JITTER_PSF_CUBE_COADD_MEDIAN "," \
        ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_MEDIAN "," \
		ERIS_IFU_PRO_JITTER_STD_FLUX_CUBE_COADD_MEDIAN "," \
        ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD_MEDIAN "," \
		ERIS_IFU_PRO_JITTER_PSF_CUBE_COADD_MEAN "," \
        ERIS_IFU_PRO_JITTER_STD_CUBE_COADD_MEAN "," \
        ERIS_IFU_PRO_JITTER_OBJ_CUBE_COADD_MEAN "," \
        ERIS_IFU_PRO_JITTER_CUBE_MEAN "," \
        ERIS_IFU_PRO_JITTER_SPECTRUM "," \
        ERIS_IFU_PRO_JITTER_SPECTRUM_FLUXCAL "," \
        ERIS_IFU_PRO_JITTER_OBJ_CUBE "," \
        ERIS_IFU_PRO_JITTER_RESPONSE "," \
        ERIS_IFU_PRO_JITTER_EXTRACTION_MASK "," \
        ERIS_IFU_PRO_JITTER_EFFICIENCY "," \
		ERIS_IFU_PRO_JITTER_EXPOSURE_MAP "," \
        ERIS_IFU_PRO_JITTER_CUBE ","


/*----------------------------------------------------------------------------
 * Product frame types for ERIS/SPIFFIER
 *--------------------------------------------------------------------------*/

#define ERIS_IFU_PRO_OBS_STD                "OBS_STD"

/*----------------------------------------------------------------------------
 * FITS extension names for OH spectra
 *--------------------------------------------------------------------------*/
#define OH_SPECTRA_J  "OHspec_J"
#define OH_SPECTRA_H  "OHspec_H"
#define OH_SPECTRA_K  "OHspec_K"
#define OH_SPECTRA_HK "OHspec_HK"

// saturation
/** @brief The saturation threshold */
#define ERIS_IFU_FLAT_SATURATED  50000

/** @brief The number of images in which a pixel must be saturated at least. */
#define ERIS_IFU_FLAT_SAT_MIN    2

/*----------------------------------------------------------------------------
 * DQI constants (Data Quality I...) (FITS16BIT)
 *--------------------------------------------------------------------------*/
//                                   Value: // Bit#:
#define ERIS_DQI_GOOD                     0 // 0:  good data
//#define ERIS_DQI_TLC_CORR               1 // 1:  affected by telluric feature (corrected)
//#define ERIS_DQI_TLC_UNCORR             2 // 2:  affected by telluric feature (uncorrected)
//#define ERIS_DQI_GHOST                  4 // 3:  ghost/stray light at >10% intensity level
#define ERIS_DQI_SAT                    8 // 4:  saturated data value
#define ERIS_DQI_BP                      16 // 5:  bad pixel (general)
//#define ERIS_DQI_NA_LASER              32 // 6:  Na-laser notch filter affected
#define ERIS_DQI_BP_BPM2D                64 // 7:  user def: bad pixel from BPM 2D
#define ERIS_DQI_BP_BPM3D               128 // 8:  user def: bad pixel from BPM 3D
#define ERIS_DQI_FLAT                   256 // 9:  user def: bad pixel from flat
#define ERIS_DQI_DETLIN                 512 // 10: user def: no linear pixel
#define ERIS_DQI_SKY                   1024 // 11: user def: added due sky subtraction
//#define ERIS_DQI_xxx                 2048 // 12: user def:
//#define ERIS_DQI_xxx                 4096 // 13: user def:
//#define ERIS_DQI_MISSING_DATA        8192 // 14: missing data
//#define ERIS_DQI_OUTSIDE_DATA_RANGE 16384 // 15: outside data range

/*----------------------------------------------------------------------------
 * Definitions for FITS files with data, error and data quality (DEQ) extens.
 *--------------------------------------------------------------------------*/
#define FHDR_HDUCLASS "HDUCLASS"
#define FHDR_HDUDOC   "HDUDOC"
#define FHDR_HDUVERS  "HDUVERS"
#define FHDR_HDUCLAS1 "HDUCLAS1"
#define FHDR_HDUCLAS2 "HDUCLAS2"
#define FHDR_HDUCLAS3 "HDUCLAS3"
#define FHDR_EXTNAME  "EXTNAME"
#define FHDR_SCIDATA  "SCIDATA"
#define FHDR_ERRDATA  "ERRDATA"
#define FHDR_QUALDATA "QUALDATA"

#define DEQ_HDUCLASS "ESO"
#define DEQ_HDUDOC   "SDP"
#define DEQ_HDUVERS  "SPD version 8"
#define DEQ_HDUCLAS1 "IMAGE"
#define DEQ_HDUCLAS2_DATA  "DATA"
#define DEQ_HDUCLAS2_ERROR "ERROR"
#define DEQ_HDUCLAS2_QUAL  "QUALITY"
#define DEQ_SCIDATA  "DATA"
#define DEQ_ERRDATA  "ERROR"
#define DEQ_QUALDATA "DQI"

typedef enum {
    mse=0,
    rmse=1,
    invmse=2,
    invrmse=3} deqErrorType;

static const char *const deqErrorTypeString[] = {
        "MSE",
        "RMSE",
        "INVMSE",
        "INVRMSE"
};

typedef enum {
    maskzero=0,
    maskone=1,
    flag32bit=2,
    flag16bit=3,
    unspecified=4} deqQualityType;

static const char *const deqQualityTypeString[] = {
        "MASKZERO",
        "MASKONE",
        "FLAG32BIT",
        "FLAG16BIT",
        "UNSPECIFIED"
};

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_boolean eris_ifu_tag_is_cdb(char *tag);
cpl_boolean eris_ifu_tag_is_sky(const char *tag);
cpl_boolean eris_ifu_tag_is_obj(const char *tag);

cpl_error_code eris_ifu_dfs_set_groups(cpl_frameset *);

cpl_frameset *
eris_ifu_extract_frameset(
        const cpl_frameset  *   in,
        const char          *   tag);

cpl_error_code eris_ifu_save_deq_image(
        cpl_frameset *allframes,
        cpl_propertylist * header,
        const cpl_parameterlist *parlist,
        const cpl_frameset *usedframes,
        const cpl_frame *inherit,
        const char *recipe,
        const cpl_propertylist *applist,
        const char *remregexp,
        const char *filename,
        const cpl_image *image,
        const cpl_image *error,
        deqErrorType errorType,
        const cpl_image *dataQualityMask,
        deqQualityType qualityType,
		const char* unit);

cpl_error_code eris_ifu_save_deq_cube(
        cpl_frameset *allframes,
        cpl_propertylist * header,
        const cpl_parameterlist *parlist,
        const cpl_frameset *usedframes,
        const cpl_frame *inherit,
        const char *recipe,
        cpl_propertylist *applist,
        const char *remregexp,
        const char *filename,
        cpl_imagelist *image,
        cpl_imagelist *error,
        deqErrorType errorType,
        const cpl_imagelist *dataQualityMask,
        deqQualityType qualityType/*,
        cpl_type imageType*/);


cpl_error_code eris_ifu_save_image_phase3(
        cpl_frameset *allframes,
//        cpl_propertylist * header,
        const cpl_parameterlist *parlist,
        const cpl_frameset *usedframes,
//        const cpl_frame *inherit,
        const char *recipe,
        const cpl_propertylist *applist,
        const char *remregexp,
        const char *filename,
        const cpl_image *image,
		cpl_type type,
		const char* unit);

cpl_error_code eris_ifu_save_table(cpl_frameset *allframes,
        cpl_propertylist *header,
        const cpl_parameterlist *parlist,
        const cpl_frameset *usedframes,
        const cpl_frame *inherit,
        const char *recipe,
        const char *procatg,
        cpl_propertylist *applist,
        const char *remregexp,
        const char *filename,
        const cpl_table *table);

//cpl_error_code eris_ifu_save_bpm(cpl_frameset *allframes,
//        cpl_propertylist *header,
//        const cpl_parameterlist *parlist,
//        const cpl_frameset *usedframes,
//        const cpl_frame *inherit,
//        const char *recipe,
//        const char *procatg,
//        cpl_propertylist *applist,
//        const char *remregexp,
//        const char *filename,
//        const cpl_image *bpm);

cpl_error_code eris_ifu_load_deq_image(
        const char *filename,
        cpl_propertylist **primaryHeader,
        cpl_image **dataImage,
        cpl_image **errImage,
        cpl_image **qualImage,
        deqErrorType *errorType,
        deqQualityType *qualityType);

cpl_error_code eris_ifu_load_deq_imagelist(
        const char *filename,
        cpl_propertylist **primaryHeader,
        cpl_imagelist **dataImagelist,
        cpl_imagelist **errImagelist,
        cpl_imagelist **qualImagelist,
        deqErrorType *errorType,
        deqQualityType *qualityType);

hdrl_image * eris_ifu_load_deq_hdrl_image(
        const char *filename,
        cpl_propertylist **primaryHeader,
        cpl_image **qualImage,
        deqQualityType *qualityType);

hdrl_imagelist * eris_ifu_load_deq_hdrl_imagelist (
        const char *filename,
        cpl_propertylist **primaryHeader,
        cpl_imagelist **qualImagelist,
        deqQualityType *qualityType);

hdrl_image *eris_ifu_load_cal_image_frame(
        const cpl_frame *frame,
        ifsBand band,
        ifsPreopticsScale scale,
        cpl_image **qualImage,
        deqQualityType *qualType);

hdrl_image *eris_ifu_load_cal_image_file(
        const char *filename,
        ifsBand band,
        ifsPreopticsScale scale,
        cpl_image **qualImage,
        deqQualityType *qualType);

cpl_error_code eris_ifu_load_distortion_polynomials_old(
        const char* filename,
        cpl_polynomial ** poly_u,
        cpl_polynomial ** poly_v);

cpl_error_code eris_ifu_load_distortion_polynomials(
        const char* filename,
        cpl_polynomial ***polynomials,
        cpl_table **borders);

cpl_vector *eris_ifu_load_distances(
        const char* filename);

cpl_bivector * eris_ifu_load_slit_positions(
        const char* filename);

cpl_error_code eris_ifu_append_qc_int(
        cpl_propertylist *pl,
        const char *name,
        int val,
        const char* comment);
cpl_error_code eris_ifu_append_qc_double(
        cpl_propertylist *pl,
        const char *name,
        double val,
        const char* comment);
cpl_error_code eris_ifu_append_qc_float(
        cpl_propertylist *pl,
        const char *name,
        float val,
        const char* comment);
cpl_error_code eris_ifu_set_qc_int(
        cpl_propertylist *pl,
        const char *name,
        int val,
        const char* comment);

bool eris_ifu_frame_is_on(const cpl_frame *fr);

bool eris_ifu_frame_is_sky(const cpl_frame *fr);

int eris_ifu_get_callamp_status(cpl_propertylist *header);

float eris_ifu_get_dit(cpl_propertylist *header);

ifsBand eris_ifu_get_band(const cpl_propertylist *header);

ifsInstrument eris_ifu_get_instrument(const cpl_propertylist *header);

ifsPreopticsScale eris_ifu_get_preopticsScale(
        cpl_propertylist *header);
cpl_error_code eris_ifu_heades_add_hduclass_common(cpl_propertylist* plist,
		const char* deq_hduclas);
cpl_error_code eris_ifu_heades_add_hduclass_data(cpl_propertylist* plist);
cpl_error_code eris_ifu_heades_add_hduclass_errs(cpl_propertylist* plist,
        deqErrorType errorType);
cpl_error_code eris_ifu_heades_add_hduclass_qual(cpl_propertylist* plist,
        deqQualityType qualityType);

ifsPreopticsScale
eris_ifu_get_spiffier_preoptics_scale(const char *scaleId);

ifsPreopticsScale
eris_ifu_get_spiffi_preoptics_scale(const char *scaleId);
double eris_get_cumoffs_ra(cpl_frame * frame);
double eris_get_cumoffs_dec(cpl_frame * frame);
double eris_get_mjd_obs(cpl_frame * frame);
cpl_error_code
eris_ifu_extract_mst_frames(const cpl_frameset * sof, cpl_frameset* cdb);
cpl_error_code
eris_ifu_extract_sky_frames(const cpl_frameset * sof, cpl_frameset* sky);
cpl_error_code
eris_ifu_extract_obj_frames(const cpl_frameset * sof, cpl_frameset* obj);

#endif
