/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERISP_ERIS_ERIS_IFU_EXTRACT_SPEC_STATIC_H_
#define ERISP_ERIS_ERIS_IFU_EXTRACT_SPEC_STATIC_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <time.h>
#include <math.h>

#include <cpl.h>
#include <hdrl.h>
#include "eris_ifu_functions.h"
#include "eris_ifu_vector.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

typedef enum {MASK, POSITION, MAX, FIT, OPTIMAL} mask_method_types;
struct esParamStruct {
        mask_method_types   mask_method;
        int                 center_x;
        int                 center_y;
        double              radius;
        productDepthType    productDepth;
        bool                save_mask;
};


struct esSofStruct {
        hdrl_imagelist      *cube;
        cpl_image           *mask;
//        cpl_image           *collapsedCube;
        cpl_propertylist    *header;
        cpl_imagelist       *qualImagelist;
        deqQualityType      qualityType;
        cpl_size            nx;
        cpl_size            ny;
        cpl_size            nz;
};


/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
void eris_ifu_extract_free_esSofStruct(struct esSofStruct* self);

hdrl_image* eris_ifu_extract_spec_collapse(hdrl_imagelist *cube,
                                           cpl_image **contribute);

cpl_image* eris_ifu_extract_spec_create_fit_mask(const hdrl_image *img);

cpl_image* eris_ifu_extract_spec_create_circle_mask(
        cpl_size center_x,
        cpl_size center_y,
        double radius,
        cpl_size nx,
        cpl_size ny);

cpl_image* eris_ifu_extract_spec_create_mask(struct esParamStruct params,
                                             struct esSofStruct sof,
                                             const hdrl_image *collapsedCube,
                                             int productDepth);

cpl_bivector* eris_ifu_extract_spectrum(
        hdrl_imagelist *cube,
        cpl_image *mask,
        double startLambda,
        double deltaLambda,
        cpl_vector **error,
        cpl_vector **totalFlux);

//cpl_bivector* eris_ifu_extract_spectrum2(
//        hdrl_imagelist *cube,
//        cpl_image *mask,
//        double startLambda,
//        double deltaLambda,
//        cpl_vector **error,
//        cpl_vector **totalFlux);

//cpl_bivector* eris_ifu_extract_spectrum3(
//        hdrl_imagelist *cube,
//        cpl_image *mask,
//        double startLambda,
//        double deltaLambda,
//        cpl_vector **error,
//        cpl_vector **totalFlux);

cpl_bivector* eris_ifu_optimal_extraction(const hdrl_imagelist  *cube,
                                          const cpl_imagelist   *cube_dqi,
                                          const cpl_image       *img_mask,
                                          double                startLambda,
                                          double                deltaLambda,
                                          int                   productDepth,
                                          cpl_vector            **error_out);

cpl_error_code eris_ifu_opt_extr_get_center_fwhm(const hdrl_image    *hdrl_img,
                                                 int                 edge_trim,
                                                 cpl_size            *xcen,
                                                 cpl_size            *ycen,
                                                 double              *fwhm);

cpl_mask* eris_ifu_opt_extr_create_mask(int nx,
                                        int ny,
                                        int xcen,
                                        int ycen,
                                        double fwhm);

cpl_error_code eris_ifu_opt_extr_simple_extraction(const hdrl_imagelist *cube,
                                                   const cpl_mask       *mask,
                                                   cpl_vector           **spec,
                                                   cpl_vector           **spec_var);

cpl_bivector * eris_ifu_opt_extr_helper_usepix(const cpl_mask *mask, int *n_usepix);

cpl_error_code eris_ifu_opt_extr_helper_fill_vertical(cpl_image *img, const eris_ifu_vector *vec);

void eris_ifu_opt_extr_helper_fill_horizontal(cpl_image *img, const cpl_image *slice, const cpl_bivector *usepix, int row, int power);

void eris_ifu_opt_extr_helper_set_positive(cpl_image *img);

cpl_vector* eris_ifu_opt_extr_get_col(const cpl_image *img, int colnr);

cpl_vector *eris_ifu_opt_extr_get_row(const cpl_image *img, int rownr);

cpl_error_code eris_ifu_opt_extr_set_row(cpl_image *img,
                                         int rownr,
                                         const cpl_vector *vec);

cpl_error_code eris_ifu_opt_extr_set_col(cpl_image *img,
                                         int colnr,
                                         const cpl_vector *vec);

cpl_vector* eris_ifu_opt_extr_create_lambda(int size,
                                        double startLambda,
                                        double deltaLambda);

cpl_error_code eris_ifu_opt_extr_vector_sqrt(cpl_vector *vec);

cpl_bivector* eris_ifu_opt_extr_doit(const hdrl_imagelist *cube,
                                        const cpl_imagelist *cube_dqi,
                                        const cpl_mask *mask,
                                        const eris_ifu_vector *spec,
                                        const eris_ifu_vector *spec_var,
                                        double startLambda,
                                        double deltaLambda,
                                        int productDepth,
                                        cpl_vector **error_out);

int eris_ifu_opt_extr_get_not_finite(cpl_vector *vec);

void eris_ifu_opt_extr_convert_0_to_NaN_vec(cpl_vector *vec);

double eris_ifu_opt_extr_estimate_radius(const cpl_image *img,
                                         cpl_size center_x,
                                         cpl_size center_y,
                                         double initial_radius,
                                         int    productDepth);

//double eris_ifu_opt_extr_median_without_NaN(cpl_vector *vec);

cpl_error_code eris_ifu_cpl_vector_sqrt(cpl_vector *vec);

#endif


