/* $Id: eris_ifu_priv_lcorr.h,v 1.8 2013-09-16 13:40:02 aagudo Exp $
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: aagudo $
 * $Date: 2013-09-16 13:40:02 $
 * $Revision: 1.8 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ERIS_IFU_LAMBDA_CORR_H
#define ERIS_IFU_LAMBDA_CORR_H

/*-----------------------------------------------------------------------------
 *                              Includes
 *----------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <cpl.h>
#include "eris_ifu_utils.h"

/*-----------------------------------------------------------------------------
 *              Types
 *-----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
 *                        Prototypes
 *----------------------------------------------------------------------------*/

cpl_polynomial *eris_ifu_lcorr_get(cpl_imagelist *cube, hdrl_imagelist *hdrlCube,
        const cpl_propertylist *header,
        cpl_vector *peaks, const int pfit_order);

cpl_bivector *eris_ifu_lcorr_extract_spectrum (const cpl_imagelist *cube,
        const cpl_propertylist *header,
        const double min_frac,
        const cpl_vector *range);

cpl_image *eris_ifu_lcorr_create_object_mask (const cpl_imagelist *cube,
        double min_frac,
        const cpl_vector *lambda,
        const cpl_vector *range);

cpl_vector *eris_ifu_lcorr_create_lambda_vector (const cpl_propertylist *header);

cpl_bivector *eris_ifu_lcorr_read_OH_reference_spectrum (const char *filename,
        cpl_size ext_number);

cpl_array *eris_ifu_lcorr_get_peak_positions(const cpl_bivector *spectrum,
        double min_frac,
        cpl_vector *range);

cpl_vector *eris_ifu_lcorr_get_peak_lambdas (const cpl_bivector *spectrum,
        double min_frac,
        cpl_vector *range);

cpl_polynomial *eris_ifu_lcorr_crosscorrelate_spectra(cpl_bivector *object,
        cpl_vector *peaks, ifsBand bandId, const int pfit_order);

int gauss1d_fnc(const double x[], const double a[], double *result);
int gauss1d_fncd(const double x[], const double a[], double result[]);
double fit_peak (const cpl_bivector *spectrum, const cpl_size size, double lambda_in, int half_width, double *sigma_par);
void eris_ifu_lcorr_open_debug_file(const char *filename);
void eris_ifu_lcorr_close_debug_file(void);

#endif
