/* $Id: eris_ifu_strehl.h,v 1.1 2011-11-02 13:14:23 amodigli Exp $
 *
 * This file is part of the irplib package
 * Copyright (C) 2002, 2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1307 USA
 */

#ifndef ERIS_IFU_STREHL_H_
#define ERIS_IFU_STREHL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include <eris_ifu_dfs.h>

cpl_error_code
eris_ifu_strehl_compute(cpl_frameset * frameset,
                        const cpl_parameterlist * parlist,
                        const char* recipe_name);

cpl_error_code
eris_ifu_stdstar_strehl_compute(cpl_frameset *frameset,
                                const cpl_parameterlist *parlist,
                                const char *context /*,
                                const char* recipe_name*/);

#endif /* ERIS_IFU_STREHL_H_ */
