/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$:
 * $Date$:
 * $Rev$:
 */

/*
 * This file defines structures and methods used to store and maintain
 * an ERIS/NIX 'gain_linearity' structure.
 */

#ifndef ERIS_NIX_GAIN_LINEARITY_H
#define ERIS_NIX_GAIN_LINEARITY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

#define MAX_LIN_DEPTH 20
#define MAX_LIN_DIFFERENCE 2.0

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "eris_nix_defs.h"

/*-----------------------------------------------------------------------------
                                   Declarations
 -----------------------------------------------------------------------------*/

typedef struct {
    cpl_imagelist    * lin_coeffs;
    double           * ordered_lin_coeffs;
    cpl_mask         * bpm;
    hdrl_value         gain;
    double             saturation_limit;
    cpl_propertylist * plist;
} gain_linearity;

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

void engl_gain_linearity_delete(gain_linearity *);

gain_linearity * engl_gain_linearity_load_from_frameset(const cpl_frameset *,
                                                        const char *,
                                                        const char *,
                                                        const char *,
                                                        const int,
                                                        cpl_frameset *)
    CPL_ATTR_ALLOC;

gain_linearity * engl_gain_linearity_test(const cpl_size ,
                                          const cpl_size,
                                          const double,
                                          const double,
                                          const double,
                                          const double,
                                          const hdrl_value,
                                          const double saturation)
    CPL_ATTR_ALLOC;

#endif /* ERIS_NIX_GAIN_LINEARITY_H */


