from adari_core.plots.images import ImagePlot
from adari_core.plots.panel import Panel
from adari_core.plots.text import TextPlot
from adari_core.report import AdariReportBase
from .eris_utils import ErisSetupInfo

from . import ErisReportMixin

import os


class ErisDistortionReport(AdariReportBase):
    def __init__(self):
        super().__init__("eris_distortion")

    def parse_sof(self):

        bpm_dist = None
        for filename, catg in self.inputs:
            if catg == "BPM_DIST":
                bpm_dist = filename

        file_lists = []
        if bpm_dist is not None:
            file_lists.append(
                {
                    "bpm": bpm_dist,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        vspace = 0.3
        ext = "PRIMARY"

        bpm = self.hdus[0]["bpm"]

        panel = Panel(2, 3, height_ratios=[1, 4, 4])

        # Text Plot
        fname = os.path.basename(str(bpm.filename()))
        instrume = str(bpm[ext].header.get("INSTRUME"))
        procatg = str(bpm[ext].header.get("HIERARCH ESO PRO CATG"))

        t1 = TextPlot(columns=1, v_space=vspace)

        col1 = (
            instrume,
            "EXTNAME: " + ext,
            "PRO CATG: " + procatg,
            "FILE NAME: " + fname,
            "RAW1 NAME: " + str(bpm[ext].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")),
        )
        t1.add_data(col1)
        panel.assign_plot(t1, 0, 0, xext=1)

        t2 = TextPlot(columns=1, v_space=vspace, xext=1)
        self.metadata = ErisSetupInfo.distortion(bpm)
        col2 = self.metadata
        t2.add_data(col2)
        panel.assign_plot(t2, 1, 0, xext=1)

        # Data Plot
        plot_data = ImagePlot(
            bpm[ext].data,
            title=procatg,
            v_clip="val",
            v_clip_kwargs={"low": 0, "high": 1},
            interpolation="none",
        )
        panel.assign_plot(plot_data, 0, 1, xext=2, yext=2)

        panels[panel] = {
            "report_name": "{}_{}".format(instrume, procatg.lower()),
            "report_description": "ERIS distortion panel - {}".format(fname),
            "report_tags": [],
        }

        return panels


rep = ErisDistortionReport()
