from adari_core.data_libs.master_calibrator_eris import MasterCalibratorReport
from adari_core.plots.panel import Panel
from adari_core.plots.text import TextPlot
from .eris_utils import ErisSetupInfo
from . import ErisReportMixin

import os


class ErisPsfReport(ErisReportMixin, MasterCalibratorReport):
    def __init__(self):
        super().__init__("eris_psf")

    def parse_sof(self):

        psf_cube_mean = None
        psf_cube = None
        psf_spectrum = None
        for filename, catg in self.inputs:
            if catg == "PSF_CUBE_MEAN":
                psf_cube_mean = filename
            elif catg == "PSF_CUBE":
                psf_cube = filename
            elif catg == "SPECTRUM":
                psf_spectrum = filename
        file_lists = []
        if (
            psf_cube_mean is not None
            and psf_cube is not None
            and psf_spectrum is not None
        ):
            file_lists.append(
                {
                    "mean": psf_cube_mean,
                    "cube": psf_cube,
                    "spec": psf_spectrum,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        vspace = 0.3

        panels = super().generate_panels(
            descr="PSF calibrator",
            collapse_y_label="ADU",
        )
        for i, (panel, panel_descr) in enumerate(panels.items()):
            mean = self.hdus[i]["mean"]

            # Text Plot
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            self.metadata = ErisSetupInfo.ifu_stdstar(mean)
            col2 = self.metadata
            t2.add_data(col2)
            panel.assign_plot(t2, 1, 0, xext=1)

        return panels


rep = ErisPsfReport()
