from adari_core.data_libs.master_calibrator_eris import MasterCalibratorReport
from adari_core.plots.panel import Panel
from adari_core.plots.text import TextPlot
from .eris_utils import ErisSetupInfo
from . import ErisReportMixin

import os


class ErisStdStarReport(ErisReportMixin, MasterCalibratorReport):
    def __init__(self):
        super().__init__("eris_std_star")

    def parse_sof(self):

        coadd_median = None
        coadd = None
        spectrum = None
        efficiency = None

        for filename, catg in self.inputs:
            if catg == "STD_FLUX_CUBE_COADD_MEDIAN":
                coadd_median = filename
            if catg == "STD_FLUX_CUBE_COADD":
                coadd = filename
            if catg == "SPECTRUM":
                spectrum = filename
            if catg == "EFFICIENCY":
                efficiency = filename

        file_lists = []
        # if coadd_median is not None and coadd is not None and spectrum is not None and efficiency is not None:
        file_lists.append(
            {"mean": coadd_median, "cube": coadd, "spec": spectrum, "eff": efficiency}
        )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        vspace = 0.3

        panels = super().generate_panels(
            descr="Std star",
            collapse_y_label="ADU",
        )
        for i, (panel, panel_descr) in enumerate(panels.items()):
            mean = self.hdus[i]["mean"]

            # Text Plot
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            self.metadata = ErisSetupInfo.ifu_stdstar(mean)
            col2 = self.metadata
            t2.add_data(col2)
            panel.assign_plot(t2, 1, 0, xext=1)

        return panels


rep = ErisStdStarReport()
