from adari_core.data_libs.master_calibrator_eris import MasterCalibratorReport
from adari_core.plots.panel import Panel
from adari_core.plots.text import TextPlot
from .eris_utils import ErisSetupInfo
from . import ErisReportMixin

import os


class ErisTelluricReport(ErisReportMixin, MasterCalibratorReport):
    def __init__(self):
        super().__init__("eris_telluric")

    def parse_sof(self):

        std_cube_median = None
        std_cube = None
        std_spectrum = None
        for filename, catg in self.inputs:
            if catg == "STD_CUBE_COADD_MEDIAN":
                std_cube_median = filename
            elif catg == "STD_CUBE_COADD":
                std_cube = filename
            elif catg == "SPECTRUM":
                std_spectrum = filename
        file_lists = []
        if (
            std_cube_median is not None
            and std_cube is not None
            and std_spectrum is not None
        ):
            file_lists.append(
                {
                    "mean": std_cube_median,
                    "cube": std_cube,
                    "spec": std_spectrum,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        vspace = 0.3

        panels = super().generate_panels(
            descr="Telluric standard star",
            collapse_y_label="ADU",
        )
        for i, (panel, panel_descr) in enumerate(panels.items()):
            mean = self.hdus[i]["mean"]

            # Text Plot
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            self.metadata = ErisSetupInfo.ifu_stdstar(mean)
            col2 = self.metadata
            t2.add_data(col2)
            panel.assign_plot(t2, 1, 0, xext=1)

        return panels


rep = ErisTelluricReport()
