from edps import classification_rule

from . import eris_keywords as kwd
from . import eris_rules as rules

# Dictionaries containing the values of header keywords that define calibrations and science data
seq_arm = kwd.seq_arm
dpr_catg = kwd.dpr_catg
dpr_type = kwd.dpr_type
pro_catg = kwd.pro_catg
eris = {kwd.instrume: "ERIS"}
spiffier = {**eris, pro_catg: None, seq_arm: "SPIFFIER"}
nix = {**eris, pro_catg: None, seq_arm: "NIX"}

calib_spiffier = {**spiffier, pro_catg: None, dpr_catg: ["CALIB", "TEST"]}
calib_nix = {**nix, pro_catg: None, dpr_catg: ["CALIB"]}
test_nix = {**nix, pro_catg: None, dpr_catg: ["TEST"]}
calib_nix_lss = {
    **calib_nix,
    kwd.dpr_tech: ["SPECTRUM,LSS,JITTER", "SPECTRUM,LSS"],
    kwd.ins1_mode: "nixLSS",
}

science_nix = {**nix, pro_catg: None, dpr_catg: ["SCIENCE"]}
science_nix_lss = {
    **science_nix,
    kwd.dpr_tech: ["SPECTRUM,LSS,JITTER", "SPECTRUM,LSS"],
    kwd.ins1_mode: "nixLSS",
}

is_long_kwd = {
    kwd.ins2_nxfw_name: [
        "Lp",
        "Short-Lp",
        "Mp",
        "Br-a",
        "L-Broad",
        "Pa-b",
        "Fe-II",
        "Br-g",
    ]
}
is_short_kwd = {
    kwd.ins2_nxfw_name: ["J", "H", "Ks", "IB-2.42", "H2-cont", "K-peak", "H2-1-0S"]
}
calib_nix_short = {**calib_nix, **is_short_kwd}
calib_nix_long = {**calib_nix, **is_long_kwd}
science_nix_short = {**science_nix, **is_short_kwd}
science_nix_long = {**science_nix, **is_long_kwd}
science_spiffier_keywords = {**spiffier, pro_catg: None, dpr_catg: "SCIENCE"}
coronagraphy = {
    **eris,
    kwd.dpr_tech: ["IMAGE,APP", "CORONAGRAPHY,APP"],
    dpr_catg: ["SCIENCE", "CALIB"],
}
coronagraphy_fpc = {
    **eris,
    kwd.dpr_tech: "CORONAGRAPHY,FPC",
    dpr_catg: ["SCIENCE", "CALIB"],
}
# ---------------- CLASSIFICATION RULES -----------------

# Raw types

persistence_nix_fast_class = classification_rule(
    "PERSISTENCE_IMA",
    {**nix, dpr_type: "PERSISTENCE", kwd.det_read_curname: "FAST_UNCORR"},
)

persistence_nix_slow_class = classification_rule(
    "PERSISTENCE_IMA",
    {**nix, dpr_type: "PERSISTENCE", kwd.det_read_curname: "SLOW_GR_UTR"},
)

persistence_sp_calib_class = classification_rule(
    "PERSISTENCE_CUBE", rules.is_persistence_spiffier_calib
)
persistence_sp_science_class = classification_rule(
    "SCI_PERSISTENCE_CUBE", rules.is_persistence_spiffier_science
)

dark_spiffier_class = classification_rule("DARK", {**calib_spiffier, dpr_type: "DARK"})
nix_dark_class = classification_rule("DARK", {**calib_nix, dpr_type: "DARK"})

linearity_class = classification_rule(
    "LINEARITY_LAMP",
    {
        **calib_spiffier,
        kwd.dpr_type: ["LINEARITY,LAMP,DETCHAR", "LINEARITY,DARK,DETCHAR"],
        kwd.tpl_id: "ERIS_ifs_tec_GainLinearity",
    },
)
linearity_on_class = classification_rule(
    "ON_RAW", {**calib_nix, dpr_type: "LINEARITY,LAMP,DETCHAR"}
)
linearity_off_class = classification_rule(
    "OFF_RAW", {**calib_nix, dpr_type: "LINEARITY,DARK,DETCHAR"}
)

# Distortion (spiffier only)
ns_slit_class = classification_rule("FIBRE_NS", {**calib_spiffier, dpr_type: "NS,SLIT"})
ns_dark_class = classification_rule("DARK_NS", {**calib_spiffier, dpr_type: "NS,DARK"})
ns_flat_class = classification_rule(
    "FLAT_NS", {**calib_spiffier, dpr_type: ["NS,FLAT,LAMP", "NS,FLAT,DARK"]}
)
ns_wave_class = classification_rule(
    "WAVE_NS", {**calib_spiffier, dpr_type: ["NS,WAVE,LAMP", "NS,WAVE,DARK"]}
)

# Spiffier Flats

flat_spiffier_class = classification_rule(
    "FLAT_LAMP", {**calib_spiffier, dpr_type: ["FLAT,DARK", "FLAT,LAMP"]}
)

# NIX flats (lamp, twilight, sky-imaging and sky-spectra)
nix_lamp_flat_on_class = classification_rule(
    "FLAT_LAMP_ON", {**calib_nix, dpr_type: "FLAT,LAMP"}
)

nix_lamp_flat_off_class = classification_rule(
    "FLAT_LAMP_OFF", {**calib_nix, dpr_type: "FLAT,DARK"}
)

nix_twilight_flat_class = classification_rule(
    "FLAT_TWILIGHT", {**calib_nix, dpr_type: ["FLAT,TWILIGHT", "FLAT,TWLIGHT"]}
)

nix_sky_flat_class = classification_rule(
    "FLAT_SKY", {**calib_nix, kwd.dpr_tech: "IMAGE", dpr_type: "FLAT,SKY"}
)

nix_sky_flat_lss_class = classification_rule(
    "FLAT_SKY", {**calib_nix, kwd.dpr_tech: "SPECTRUM,LSS", dpr_type: "FLAT,SKY"}
)

wave_class = classification_rule(
    "WAVE_LAMP", {**calib_spiffier, dpr_type: ["WAVE,DARK", "WAVE,LAMP"]}
)

# On sky exposures:
# Standard stars spiffier
obj_std_nodding_class = classification_rule(
    "STD", {**calib_spiffier, dpr_type: "STD", kwd.tpl_id: "ERIS_ifs_cal_StandardStar"}
)
sky_std_nodding_class = classification_rule(
    "SKY_STD",
    {**calib_spiffier, dpr_type: "SKY,STD", kwd.tpl_id: "ERIS_ifs_cal_StandardStar"},
)
obj_std_flux_nodding_class = classification_rule(
    "STD_FLUX",
    {**calib_spiffier, dpr_type: "STD,FLUX", kwd.tpl_id: "ERIS_ifs_cal_SpecPhot"},
)
sky_std_flux_nodding_class = classification_rule(
    "SKY_STD_FLUX",
    {**calib_spiffier, dpr_type: "SKY,STD,FLUX", kwd.tpl_id: "ERIS_ifs_cal_SpecPhot"},
)

# On-sky observations (science, standard, astrometry) NIX
nix_std_jitter_short_class = classification_rule(
    "STD_JITTER", rules.is_std_jitter_short
)
nix_sky_jitter_short_class = classification_rule(
    "SKY_JITTER", rules.is_sky_jitter_short
)

nix_std_jitter_long_class = classification_rule(
    "STD_JITTER",
    {
        **calib_nix_long,
        kwd.dpr_tech: "IMAGE",
        kwd.det_fram_format: "single",
        kwd.dpr_type: ["STD", "OBJECT"],
    },
)
nix_sky_jitter_long_class = classification_rule("SKY_JITTER", rules.is_sky_jitter_long)
nix_std_jitter_short_cube_class = classification_rule(
    "STD_JITTER", rules.is_std_cube_jitter_short
)
nix_sky_jitter_short_cube_class = classification_rule(
    "SKY_JITTER", rules.is_sky_cube_jitter_short
)
nix_std_jitter_long_cube_class = classification_rule(
    "STD_JITTER", rules.is_std_cube_jitter_long
)
nix_sky_jitter_long_cube_class = classification_rule(
    "SKY_JITTER", rules.is_sky_cube_jitter_long
)
nix_object_jitter_short_class = classification_rule(
    "OBJECT_JITTER",
    {
        **science_nix_short,
        kwd.dpr_type: "OBJECT",
        kwd.det_fram_format: "single",
        kwd.ins1_mode: "nixIMG",
        kwd.dpr_tech: ["IMAGE,JITTER", "IMAGE", "IMAGE,PT"],
        kwd.tpl_id: ["ERIS_nixIMG_obs_AutoJitter", "ERIS_nixIMG_obs_GenericOffset"],
    },
)
nix_object_jitter_long_class = classification_rule(
    "OBJECT_JITTER",
    {
        **science_nix_long,
        kwd.dpr_type: "OBJECT",
        kwd.det_fram_format: "single",
        kwd.ins1_mode: "nixIMG",
        kwd.dpr_tech: ["IMAGE,JITTER", "IMAGE", "IMAGE,PT"],
        kwd.tpl_id: ["ERIS_nixIMG_obs_AutoJitter", "ERIS_nixIMG_obs_GenericOffset"],
    },
)

nix_object_jitter_short_cube_class = classification_rule(
    "OBJECT_JITTER",
    {
        **science_nix_short,
        kwd.dpr_type: "OBJECT",
        kwd.det_fram_format: "cube",
        kwd.ins1_mode: "nixIMG",
        kwd.dpr_tech: ["IMAGE,JITTER", "IMAGE", "IMAGE,PT"],
        kwd.tpl_id: ["ERIS_nixIMG_obs_AutoJitter", "ERIS_nixIMG_obs_GenericOffset"],
    },
)
nix_object_jitter_long_cube_class = classification_rule(
    "OBJECT_JITTER",
    {
        **science_nix_long,
        kwd.dpr_type: "OBJECT",
        kwd.det_fram_format: "cube",
        kwd.ins1_mode: "nixIMG",
        kwd.dpr_tech: ["IMAGE,JITTER", "IMAGE", "IMAGE,PT"],
        kwd.tpl_id: ["ERIS_nixIMG_obs_AutoJitter", "ERIS_nixIMG_obs_GenericOffset"],
    },
)

nix_std_astrometry_short_class = classification_rule(
    "STD_JITTER", rules.is_std_astrometry_short
)
nix_sky_astrometry_short_class = classification_rule(
    "SKY_JITTER", rules.is_sky_astrometry_short
)
nix_std_astrometry_long_class = classification_rule(
    "STD_JITTER", rules.is_std_astrometry_long
)
nix_sky_astrometry_long_class = classification_rule(
    "SKY_JITTER", rules.is_std_astrometry_long
)

nix_std_astrometry_short_cube_class = classification_rule(
    "STD_JITTER", rules.is_std_cube_astrometry_short
)
nix_sky_astrometry_short_cube_class = classification_rule(
    "SKY_JITTER", rules.is_sky_cube_astrometry_short
)
nix_std_astrometry_long_cube_class = classification_rule(
    "STD_JITTER", rules.is_std_cube_astrometry_long
)
nix_sky_astrometry_long_cube_class = classification_rule(
    "SKY_JITTER", rules.is_sky_cube_astrometry_long
)

nix_object_astrometry_jitter_short_class = classification_rule(
    "OBJECT_JITTER",
    {
        **science_nix_short,
        kwd.dpr_type: "ASTROMETRY",
        kwd.det_fram_format: "single",
        kwd.ins1_mode: "nixIMG",
        kwd.dpr_tech: ["IMAGE,JITTER", "IMAGE"],
        kwd.tpl_id: ["ERIS_nixIMG_obs_AutoJitter", "ERIS_nixIMG_obs_GenericOffset"],
    },
)

nix_object_astrometry_jitter_long_class = classification_rule(
    "OBJECT_JITTER",
    {
        **science_nix_long,
        kwd.dpr_type: "ASTROMETRY",
        kwd.det_fram_format: "single",
        kwd.ins1_mode: "nixIMG",
        kwd.dpr_tech: ["IMAGE,JITTER", "IMAGE"],
        kwd.tpl_id: ["ERIS_nixIMG_obs_AutoJitter", "ERIS_nixIMG_obs_GenericOffset"],
    },
)
#
nix_object_astrometry_jitter_short_cube_class = classification_rule(
    "OBJECT_JITTER",
    {
        **science_nix_short,
        kwd.dpr_type: "ASTROMETRY",
        kwd.det_fram_format: "cube",
        kwd.ins1_mode: "nixIMG",
        kwd.dpr_tech: ["IMAGE,JITTER", "IMAGE"],
        kwd.tpl_id: ["ERIS_nixIMG_obs_AutoJitter", "ERIS_nixIMG_obs_GenericOffset"],
    },
)

nix_object_astrometry_jitter_long_cube_class = classification_rule(
    "OBJECT_JITTER",
    {
        **science_nix_long,
        kwd.dpr_type: "ASTROMETRY",
        kwd.det_fram_format: "cube",
        kwd.ins1_mode: "nixIMG",
        kwd.dpr_tech: ["IMAGE,JITTER", "IMAGE"],
        kwd.tpl_id: ["ERIS_nixIMG_obs_AutoJitter", "ERIS_nixIMG_obs_GenericOffset"],
    },
)

# NIX Long Slit Spectroscopy (LSS)
nix_std_jitter_lss = classification_rule(
    "STD_LSS_JITTER", {**calib_nix_lss, kwd.dpr_type: "STD"}
)
nix_sky_std_jitter_lss = classification_rule(
    "SKY_STD_LSS_JITTER", {**calib_nix_lss, kwd.dpr_type: "SKY,STD"}
)

nix_object_jitter_lss = classification_rule(
    "OBJECT_LSS_JITTER", {**science_nix_lss, kwd.dpr_type: "OBJECT"}
)
nix_sky_jitter_lss = classification_rule(
    "SKY_LSS_JITTER", {**science_nix_lss, kwd.dpr_type: "SKY"}
)

# Spiffier on-sky observations

obj_nodding_class = classification_rule(
    "OBJ",
    {**science_spiffier_keywords, dpr_type: "OBJECT", kwd.dpr_tech: "IFU,NODDING"},
)

obj_jitter_class = classification_rule(
    "OBJ", {**science_spiffier_keywords, dpr_type: "OBJECT", kwd.dpr_tech: "IFU,JITTER"}
)

sky_ifu_class = classification_rule(
    "SKY_OBJ",
    {
        **science_spiffier_keywords,
        dpr_type: "SKY",
        kwd.dpr_tech: ["IFU,JITTER", "IFU,NODDING"],
    },
)

psf_object_class = classification_rule("PSF_CALIBRATOR", rules.is_obj_psf)
psf_sky_class = classification_rule("SKY_PSF_CALIBRATOR", rules.is_sky_psf)
strehl_object_class = classification_rule("PSF_CALIBRATOR", rules.is_obj_strehl)
strehl_sky_class = classification_rule("SKY_PSF_CALIBRATOR", rules.is_sky_strehl)

# NIX coronagraphy
object_coronagraphy_class = classification_rule(
    "OBJECT_APP", {**coronagraphy, dpr_type: "OBJECT"}
)
sky_coronagraphy_class = classification_rule(
    "SKY_APP", {**coronagraphy, dpr_type: "SKY"}
)
flat_coronography_class = classification_rule(
    "FLAT_SKY", {**coronagraphy, dpr_type: "FLAT,SKY"}
)
object_fpc_class = classification_rule(
    "OBJECT_FPC", {**coronagraphy_fpc, dpr_type: ["OBJECT", "OBJECT,PSF"]}
)
sky_fpc_class = classification_rule(
    "SKY_FPC", {**coronagraphy_fpc, dpr_type: ["SKY", "SKY,PSF"]}
)
sky_coro_class = classification_rule("SKY_CORO", {**eris, dpr_type: "SKY,CORO"})

# NIX Sparse Aperture Mask (SAM)
object_sam_class = classification_rule(
    "OBJECT_SAM", {**nix, kwd.dpr_tech: "IMAGE,SAM", dpr_type: "OBJECT"}
)

# Acquisitions
acquisition_class = classification_rule(
    "ACQUISITION", {**eris, dpr_catg: "ACQUISITION"}
)
object_sky_opt_class = classification_rule(
    "ACQUISITION", {**eris, dpr_type: ["OBJECT,OPT", "SKY,OPT"]}
)
# PUPIL classification
pupil_spiffier_lamp_class = classification_rule(
    "PUPIL_LAMP", {**calib_spiffier, kwd.dpr_type: "PUPIL,LAMP"}
)
pupil_spiffier_sky_class = classification_rule(
    "PUPIL_SKY", {**calib_spiffier, kwd.dpr_type: "PUPIL,SKY"}
)

pupil_nix_lamp_class = classification_rule(
    "PUPIL_LAMP", {**calib_nix, kwd.dpr_type: "PUPIL,LAMP"}
)
pupil_nix_sky_class = classification_rule(
    "PUPIL_SKY", {**calib_nix, kwd.dpr_type: "PUPIL,SKY"}
)
pupil_nix_background_class = classification_rule(
    "PUPIL_BACKGROUND", {**calib_nix, kwd.dpr_type: "PUPIL,BACKGROUND"}
)

pupil_ref_class = classification_rule("PUPIL_REF", {**eris, pro_catg: "PUPIL_REF"})
sam_info_class = classification_rule("SAM_INFO", {**eris, pro_catg: "SAM_INFO"})
CAL_DET_PUPIL_LAMP = classification_rule(
    "CAL_DET_PUPIL_LAMP", {**eris, pro_catg: "CAL_DET_PUPIL_LAMP"}
)

# -- MASTER CALIBRATIONS
# SPIFFIER
MASTER_DARK_IFU = classification_rule(
    "MASTER_DARK_IFU", {**eris, pro_catg: "MASTER_DARK_IFU"}
)
BPM_DARK_IFU = classification_rule("BPM_DARK", {**eris, pro_catg: "BPM_DARK"})
BPM_DETLIN_IFU = classification_rule("BPM_DETLIN", {**eris, pro_catg: "BPM_DETLIN"})
bpm_detlin_filt_class = classification_rule(
    "BPM_DETLIN_FILT", {**eris, pro_catg: "BPM_DETLIN_FILT"}
)
DISTORTION = classification_rule("DISTORTION", {**eris, pro_catg: "DISTORTION"})
bpm_dist_class = classification_rule("BPM_DIST", {**eris, pro_catg: "BPM_DIST"})
# NIX
GAIN_INFO = classification_rule("GAIN_INFO", {**eris, pro_catg: "GAIN_INFO"})
DET_LIN_INFO = classification_rule("DET_LIN_INFO", {**eris, pro_catg: "DET_LIN_INFO"})
COEFFS_CUBE = classification_rule("COEFFS_CUBE", {**eris, pro_catg: "COEFFS_CUBE"})
BP_MAP_NL = classification_rule("BP_MAP_NL", {**eris, pro_catg: "BP_MAP_NL"})
MASTER_DARK_IMG = classification_rule(
    "MASTER_DARK_IMG", {**eris, pro_catg: "MASTER_DARK_IMG"}
)
OBJECT_CUBE_COADD = classification_rule(
    "OBJECT_CUBE_COADD", {**eris, pro_catg: "OBJECT_CUBE_COADD"}
)
OBJECT_CUBE_MEAN = classification_rule(
    "OBJECT_CUBE_MEAN", {**eris, pro_catg: "OBJECT_CUBE_MEAN"}
)
EXPOSURE_MAP = classification_rule("EXPOSURE_MAP", {**eris, pro_catg: "EXPOSURE_MAP"})

# Static calibrations
ref_line_arc_class = classification_rule(
    "REF_LINE_ARC", {**eris, pro_catg: "REF_LINE_ARC"}
)
efficiency_windows_class = classification_rule(
    "EFFICIENCY_WINDOWS", {**eris, pro_catg: "EFFICIENCY_WINDOWS"}
)
response_windows_class = classification_rule(
    "RESPONSE_WINDOWS", {**eris, pro_catg: "RESPONSE_WINDOWS"}
)
extcoeff_table_class = classification_rule(
    "EXTCOEFF_TABLE", {**eris, pro_catg: "EXTCOEFF_TABLE"}
)
flux_std_catalog_class = classification_rule(
    "FLUX_STD_CATALOG", {**eris, pro_catg: "FLUX_STD_CATALOG"}
)
tell_mod_catalog_class = classification_rule(
    "TELL_MOD_CATALOG", {**eris, pro_catg: "TELL_MOD_CATALOG"}
)
fit_areas_class = classification_rule("FIT_AREAS", {**eris, pro_catg: "FIT_AREAS"})
quality_areas_class = classification_rule(
    "QUALITY_AREAS", {**eris, pro_catg: "QUALITY_AREAS"}
)
resp_fit_points_catalog_class = classification_rule(
    "RESP_FIT_POINTS_CATALOG", {**eris, pro_catg: "RESP_FIT_POINTS_CATALOG"}
)
high_abs_regions_class = classification_rule(
    "HIGH_ABS_REGIONS", {**eris, pro_catg: "HIGH_ABS_REGIONS"}
)
ref_bp_map_class = classification_rule("REF_BP_MAP", {**eris, pro_catg: "REF_BP_MAP"})
first_wave_fit_class = classification_rule(
    "FIRST_WAVE_FIT", {**eris, pro_catg: "FIRST_WAVE_FIT"}
)
wave_setup_class = classification_rule("WAVE_SETUP", {**eris, pro_catg: "WAVE_SETUP"})
oh_spec_class = classification_rule("OH_SPEC", {**eris, pro_catg: "OH_SPEC"})
atm_ref_corr_class = classification_rule(
    "ATM_REF_CORR", {**eris, pro_catg: "ATM_REF_CORR"}
)
# NIX
nix_phot_data_class = classification_rule("PHOT_DATA", {**eris, pro_catg: "PHOT_DATA"})
nix_wcs_matched_catalogue_class = classification_rule(
    "WCS_MATCHED_CATALOGUE", {**eris, pro_catg: "WCS_MATCHED_CATALOGUE"}
)

nix_wcs_refine_class = classification_rule(
    "WCS_REFINE", {**eris, pro_catg: "WCS_REFINE"}
)
nix_master_startrace_class = classification_rule(
    "MASTER_STARTRACE", {**eris, pro_catg: "MASTER_STARTRACE"}
)

# Master calibrations
BPM_FLAT = classification_rule("BPM_FLAT", {**eris, pro_catg: "BPM_FLAT"})
MASTER_FLAT_LAMP = classification_rule("MASTER_FLAT", {**eris, pro_catg: "MASTER_FLAT"})
MASTER_FLAT_LAMP_HIFREQ = classification_rule(
    "MASTER_FLAT_LAMP_HIFREQ", {**eris, pro_catg: "MASTER_FLAT_LAMP_HIFREQ"}
)
MASTER_FLAT_LAMP_LOFREQ = classification_rule(
    "MASTER_FLAT_LAMP_LOFREQ", {**eris, pro_catg: "MASTER_FLAT_LAMP_LOFREQ"}
)

MASTER_FLAT_LSS_HIFREQ = classification_rule(
    "MASTER_FLAT_LSS_HIFREQ", {**eris, pro_catg: "MASTER_FLAT_LSS_HIFREQ"}
)

MASTER_BPM_LAMP = classification_rule(
    "MASTER_BPM_LAMP", {**eris, pro_catg: "MASTER_BPM_LAMP"}
)
MASTER_BPM_SKY = classification_rule(
    "MASTER_BPM_SKY", {**eris, pro_catg: "MASTER_BPM_SKY"}
)

MASTER_BPM_LSS = classification_rule(
    "MASTER_BPM_LSS", {**eris, pro_catg: "MASTER_BPM_LSS"}
)

MASTER_FLAT_TWILIGHT_HIFREQ = classification_rule(
    "MASTER_FLAT_TWILIGHT_HIFREQ", {**eris, pro_catg: "MASTER_FLAT_TWILIGHT_HIFREQ"}
)
MASTER_FLAT_TWILIGHT_LOFREQ = classification_rule(
    "MASTER_FLAT_TWILIGHT_LOFREQ", {**eris, pro_catg: "MASTER_FLAT_TWILIGHT_LOFREQ"}
)

MASTER_SKY_LOFREQ = classification_rule(
    "MASTER_FLAT_SKY_LOFREQ", {**eris, pro_catg: "MASTER_FLAT_SKY_LOFREQ"}
)
MASTER_FLAT_SKY_HIFREQ = classification_rule(
    "MASTER_FLAT_SKY_HIFREQ", {**eris, pro_catg: "MASTER_FLAT_SKY_HIFREQ"}
)

WAVE_MAP = classification_rule("WAVE_MAP", {**eris, pro_catg: "WAVE_MAP"})
RESPONSE = classification_rule("RESPONSE", {**eris, pro_catg: "RESPONSE"})
