from edps import task, qc1calib, subworkflow, ReportInput

from .eris_datasources import *
from .eris_task_function import set_detmon_thresholds


@subworkflow("detector_calibration", "")
def detector_calibration():
    # Compute the linearity correction for NIX observations
    linearity_nix = (task('linearity_nix')
                     .with_recipe('eris_nix_detmon_ir_lg')
                     .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                     .with_report("eris_detmon", ReportInput.RECIPE_INPUTS_OUTPUTS)
                     .with_main_input(raw_linearity_nix)
                     .with_job_processing(set_detmon_thresholds)
                     .with_meta_targets([qc1calib])
                     .build())

    # Processes raw darks for NIX observations
    dark_nix = (task('dark_nix')
                .with_recipe('eris_nix_dark')
                .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                .with_report("eris_master_dark", ReportInput.RECIPE_INPUTS_OUTPUTS)
                .with_main_input(raw_nix_dark)
                .with_associated_input(linearity_nix, [GAIN_INFO])
                .with_meta_targets([qc1calib])
                .build())

    return linearity_nix, dark_nix
