from edps import subworkflow, task, qc1calib, calchecker, ReportInput

from .eris_datasources import *
from .eris_task_function import force_dark, force_linearity


@subworkflow("standard_star", "")
def standard_star(raw_std_flux_ifu, raw_std_tell_ifu, distortion, flat, wave, dark_ifu, linearity_ifu):
    # This subworkflow process flux and telluric standards for SPIFFIER mode.
    flux_standard = (task('flux_std_ifu')
                     .with_recipe('eris_ifu_stdstar')
                     .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                     .with_report("eris_std_star", ReportInput.RECIPE_INPUTS_OUTPUTS)
                     .with_main_input(raw_std_flux_ifu)
                     .with_associated_input(distortion, [DISTORTION])
                     .with_associated_input(flat, [MASTER_FLAT_LAMP, BPM_FLAT])
                     .with_associated_input(wave, [WAVE_MAP])
                     .with_associated_input(dark_ifu, [MASTER_DARK_IFU, BPM_DARK_IFU], condition=force_dark)
                     .with_associated_input(linearity_ifu, [BPM_DETLIN_IFU], condition=force_linearity)
                     .with_associated_input(efficiency_windows)
                     .with_associated_input(response_windows, min_ret=0)
                     .with_associated_input(extcoeff_table)
                     .with_associated_input(flux_std_catalog)
                     .with_associated_input(tell_mod_catalog)
                     .with_associated_input(atm_ref_corr, min_ret=0)
                     .with_associated_input(fit_areas, min_ret=0)
                     .with_associated_input(quality_areas, min_ret=0)
                     .with_associated_input(resp_fit_points_catalog)
                     .with_associated_input(high_abs_regions)
                     .with_associated_input(oh_spectrum)
                     .with_input_filter(DISTORTION, MASTER_FLAT_LAMP, BPM_FLAT, WAVE_MAP,
                                        RESPONSE)
                     .with_meta_targets([qc1calib, calchecker])
                     .build())

    telluric_standard_ifu = (task('telluric_std_ifu')
                             .with_recipe('eris_ifu_stdstar')
                             .with_report("eris_rawdisp", ReportInput.RECIPE_INPUTS)
                             .with_report("eris_telluric", ReportInput.RECIPE_INPUTS_OUTPUTS)
                             .with_main_input(raw_std_tell_ifu)
                             .with_associated_input(distortion, [DISTORTION])
                             .with_associated_input(flat, [MASTER_FLAT_LAMP, BPM_FLAT])
                             .with_associated_input(wave, [WAVE_MAP])
                             .with_associated_input(oh_spectrum)
                             .with_associated_input(quality_areas, min_ret=0)
                             .with_associated_input(fit_areas, min_ret=0)
                             .with_input_filter(DISTORTION, MASTER_FLAT_LAMP, BPM_FLAT, WAVE_MAP,
                                                RESPONSE)
                             .with_meta_targets([qc1calib])
                             .build())

    return flux_standard, telluric_standard_ifu
