/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$:
 * $Date$:
 * $Rev$:
 */

/*
 * This file defines constants and methods to create and manipulate a
 * 'master_bpm' structure. This contains a cpl_image of data type CPL_INT,
 * whose pixels can have bits set to reflect the nature of any associated
 * problem. The format follows the data quality format described in the 
 * 'Euro3D Data Format' document.
 */

#ifndef ERIS_NIX_MASTER_BPM_H
#define ERIS_NIX_MASTER_BPM_H

#define MASTER_BPM_INITIALISE {NULL, 1<<7, 1<<8, 1<<9, 1<<14, 1<<16}

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

/*-----------------------------------------------------------------------------
                                   Declarations
 -----------------------------------------------------------------------------*/

typedef struct {
    const char             * filename;
    const cpl_image        * bpm;
    const cpl_propertylist * plist;
} master_bpm;

typedef enum {BPM_GOOD,
              BPM_CORRECTED_TELLURIC,
              BPM_UNCORRECTED_TELLURIC,
              BPM_STRAY_LIGHT,
              BPM_ELECTRONIC_PICKUP,
              BPM_COSMIC_RAY_REMOVED,
              BPM_COSMIC_RAY_UNREMOVED,
              BPM_LOW_QE,
              BPM_FLAGGED_BY_CALIBRATION,
              BPM_HOT,
              BPM_DARK,
              BPM_QUESTIONABLE,
              BPM_DETECTOR_SATURATION,
              BPM_ATOD_SATURATION,
              BPM_CAMERA_DEFECT,
              BPM_BAD,
              BPM_NON_LINEAR,
              BPM_UNILLUMINATED,
              BPM_UNDEF_18,
              BPM_UNDEF_19,
              BPM_UNDEF_20, 
              BPM_UNDEF_21,
              BPM_UNDEF_22,
              BPM_UNDEF_23,
              BPM_UNDEF_24,
              BPM_UNDEF_25,
              BPM_UNDEF_26,
              BPM_UNDEF_27,
              BPM_UNDEF_28,
              BPM_UNDEF_29,
              BPM_MISSING,
              BPM_OUTSIDE_RANGE} bpm_code;

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

master_bpm * en_master_bpm_create(const char *,
                                  const cpl_mask *,
                                  const bpm_code,
                                  const cpl_propertylist *);

master_bpm * en_master_bpm_create_from_image(const char *,
                                             const cpl_image *,
                                             const cpl_propertylist *);

void en_master_bpm_delete(master_bpm *);

cpl_mask * en_master_bpm_get_mask(const master_bpm *, const int);

master_bpm * en_master_bpm_load_from_frameset(const cpl_frameset *,
                                              const char *,
                                              cpl_frameset *,
                                              const int);

cpl_error_code en_master_bpm_set(master_bpm *, const cpl_mask *, bpm_code); 
  

#endif /* ERIS_NIX_MASTER_BPM_H */


