/* $Id: eris_nix_pupil_monitor-test.c,v 1.6 2013-03-25 11:46:49 cgarcia Exp $
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-03-25 11:46:49 $
 * $Revision: 1.6 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/
#include <limits.h>
#include <eris_utils.h>
#define HDRL_USE_PRIVATE YES
#define ERIS_TIME_START(what) cpl_msg_debug(cpl_func,"Timing (%s, l%d) %s start", \
                         __FILE__, __LINE__, what)
#define ERIS_TIME_END cpl_msg_debug(cpl_func, "Timing (%s, l%d) end", \
                         __FILE__, __LINE__)


/*----------------------------------------------------------------------------*/
/**
 * @defgroup eris_nix_pupil_monitor_test  Unit test of eris_nix_pupil_monitor
 *
 */
/*----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

/*
 * =============================================================================
 * HDRL BASED CODE BELOW
 * =============================================================================
 */

struct drl_result_t
{
	cpl_image * image;
	cpl_image * error;
	cpl_mask  * mask;
	cpl_table * table;
	cpl_propertylist * qclist;

};
typedef struct drl_result_t drl_result_t;

struct drl_hough_transform_t
{
   float    thre;
   double   theta_min;
   double   theta_max;
   int      ntheta;
   double   rho_min;
   double   rho_max;
   int      nrho;
};
typedef struct drl_hough_transform_t drl_hough_transform_t;


drl_result_t * drl_result_new(void);

/* ************************************************************************
			Routines to compute Hough Transform
 **************************************************************************/
cpl_image *hough_transform (cpl_image *img, float thre);
drl_result_t *drl_hough_transform (cpl_image *img, drl_hough_transform_t * fcontrol);
drl_hough_transform_t * drl_hough_transform_new(void);
void drl_hough_transform_delete(drl_hough_transform_t * fcontrol);
void drl_result_delete(drl_result_t * result);
cpl_mask *hough_inverse_transform(cpl_image *himg, float thre, int lx, int ly);
/*
 * =============================================================================
 * HDRL BASED CODE ABOVE
 * =============================================================================
 */


/**@}*/
