# ERIS_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([ERIS_SET_VERSION_INFO],
[
    eris_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    eris_major_version=`echo "$eris_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    eris_minor_version=`echo "$eris_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    eris_micro_version=`echo "$eris_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$eris_major_version"; then eris_major_version=0
    fi

    if test -z "$eris_minor_version"; then eris_minor_version=0
    fi

    if test -z "$eris_micro_version"; then eris_micro_version=0
    fi

    ERIS_VERSION="$eris_version"
    ERIS_MAJOR_VERSION=$eris_major_version
    ERIS_MINOR_VERSION=$eris_minor_version
    ERIS_MICRO_VERSION=$eris_micro_version

    if test -z "$4"; then ERIS_INTERFACE_AGE=0
    else ERIS_INTERFACE_AGE="$4"
    fi

    ERIS_BINARY_AGE=`expr 100 '*' $ERIS_MINOR_VERSION + $ERIS_MICRO_VERSION`
    ERIS_BINARY_VERSION=`expr 10000 '*' $ERIS_MAJOR_VERSION + \
                          $ERIS_BINARY_AGE`

    AC_SUBST(ERIS_VERSION)
    AC_SUBST(ERIS_MAJOR_VERSION)
    AC_SUBST(ERIS_MINOR_VERSION)
    AC_SUBST(ERIS_MICRO_VERSION)
    AC_SUBST(ERIS_INTERFACE_AGE)
    AC_SUBST(ERIS_BINARY_VERSION)
    AC_SUBST(ERIS_BINARY_AGE)

    AC_DEFINE_UNQUOTED(ERIS_MAJOR_VERSION, $ERIS_MAJOR_VERSION,
                       [ERIS major version number])
    AC_DEFINE_UNQUOTED(ERIS_MINOR_VERSION, $ERIS_MINOR_VERSION,
                       [ERIS minor version number])
    AC_DEFINE_UNQUOTED(ERIS_MICRO_VERSION, $ERIS_MICRO_VERSION,
                       [ERIS micro version number])
    AC_DEFINE_UNQUOTED(ERIS_INTERFACE_AGE, $ERIS_INTERFACE_AGE,
                       [ERIS interface age])
    AC_DEFINE_UNQUOTED(ERIS_BINARY_VERSION, $ERIS_BINARY_VERSION,
                       [ERIS binary version number])
    AC_DEFINE_UNQUOTED(ERIS_BINARY_AGE, $ERIS_BINARY_AGE,
                       [ERIS binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# ERIS_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([ERIS_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$privatelibdir"; then
        privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi

    if test -z "$apidocdir"; then
        apidocdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}/html'
    fi

    if test -z "$pipedocsdir"; then
        pipedocsdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}'
    fi

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    if test -z "$wkfextradir"; then
        wkfextradir='${datadir}/esopipes/${PACKAGE}-${VERSION}/reflex'
    fi

    if test -z "$wkfcopydir"; then
        wkfcopydir='${datadir}/reflex/workflows/${PACKAGE}-${VERSION}'
    fi

    if test -z "$workflowdir"; then
        workflowdir='${datadir}/esopipes/workflows/${PACKAGE}-${VERSION}/${PACKAGE}'
    fi

    if test -z "$reportsdir"; then
        reportsdir='${datadir}/esopipes/reports/${PACKAGE}-${VERSION}'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(privatelibdir)
    AC_SUBST(apidocdir)
    AC_SUBST(pipedocsdir)
    AC_SUBST(configdir)
    AC_SUBST(wkfextradir)
    AC_SUBST(wkfcopydir)
    AC_SUBST(workflowdir)
    AC_SUBST(reportsdir)


])


# ERIS_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([ERIS_CREATE_SYMBOLS],
[
    SKYCORR_INCLUDES='-I$(top_srcdir)/eris/skycorr'
    SKYCORR_LDFLAGS='-L$(top_builddir)/eris/skycorr'
    
    AC_SUBST(SKYCORR_INCLUDES)
    AC_SUBST(SKYCORR_LDFLAGS)

    # Symbols for package include file and library search paths

    ERIS_INCLUDES='-I$(top_srcdir)/eris -I$(top_srcdir)/irplib -I$(top_srcdir)/casu/src -I$(top_srcdir)/casu/src/catalogue'
    ERIS_LDFLAGS='-L$(top_builddir)/eris -L$(top_srcdir)/casu/src -L$(top_srcdir)/casu/src/catalogue'
    CASU_INCLUDES='-I$(top_srcdir)/casu/src -I$(top_srcdir)/casu/src/catalogue'
    CASU_LDFLAGS='-L$(top_srcdir)/casu/src -L$(top_srcdir)/casu/src/catalogue'
    # Library aliases

    LIBERIS='$(top_builddir)/eris/liberis.la'
    LIBIRPLIB='$(top_builddir)/irplib/libirplib.la'
    LIBCASU='$(top_builddir)/casu/src/libcasu.la'
    LIBCASUCAT='$(top_builddir)/casu/src/catalogue/libcasu_catalogue.la'

    # Substitute the defined symbols

    AC_SUBST(ERIS_INCLUDES)
    AC_SUBST(ERIS_LDFLAGS)

    AC_SUBST(LIBERIS)
    AC_SUBST(LIBIRPLIB)
    AC_SUBST(LIBCASU)
    AC_SUBST(LIBCASUCAT)

    AC_SUBST(CASU_INCLUDES)
    AC_SUBST(CASU_LDFLAGS)
    # Check for CPL and user defined libraries
    AC_REQUIRE([CPL_CHECK_LIBS])
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(ERIS_INCLUDES) $(HDRL_INCLUDES) $(CASU_INCLUDES) $(CASU_INCLUDES)$(CPL_INCLUDES) $(EXTRA_INCLUDES) $(XXCLIPM_INCLUDES) $(SKYCORR_INCLUDES)'
    all_ldflags='$(ERIS_LDFLAGS) $(HDRL_LDFLAGS) $(CASU_LDFLAGS) $(CPL_LDFLAGS) $(EXTRA_LDFLAGS) $(XXCLIPM_LDFLAGS) $(SKYCORR_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])
