/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERISP_ERIS_ERIS_IFU_JITTER_INTERFACE_H_
#define ERISP_ERIS_ERIS_IFU_JITTER_INTERFACE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <time.h>
#include <math.h>

#include <cpl.h>
#include <hdrl.h>
#include "eris_ifu_functions.h"
#include "eris_ifu_extract_spec_static.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/
typedef enum {M_UNSET, M_SCIENCE, M_STDSTAR, M_PUPIL, M_TELLURIC} jitterModes;

typedef enum {NONE=0, DAVIES=1, AUSTRIAN=2} skyTweakModes;

typedef enum {LINEAR=1, SPLINE=2} stretchResamplingModes;

typedef enum {UNSET, DISTANCES, EDGES, GRID } slitletDetectionModes;

struct paramStruct {
        skyTweakModes           skyTweak;
        bool                    skip_sky_oh_align;
        bool                    skip_oh_align;
        bool                    discard_subband;
        bool                    stretch_sky;
        int                     stretch_degree;
        stretchResamplingModes  stretch_resampling;
        bool                    tbsub;
        double                  velocityOffset;
        double                  bpmThreshold;
        slitletDetectionModes   slitletDetectionMode; // SINFONI resampling
        double                  firstCol;             // SINFONI resampling
        int                     fineTuneMode;         // SINFONI resampling
        bool                    combine;
        bool                    darCorrection;
        int                     darShiftMethod;
        double                  darShiftWidth;
        int                     darShiftLength;
        bool                    resampleExposureMap;
        bool                    extractSource;
        double                  derot_corr;
        int                     bpc_iter; 
};

/*
struct objectSkyPairStruct {
        hdrl_image  *object;
        hdrl_image  *sky;
        cpl_image  *resampledImg;
        cpl_propertylist *objHdr;
        cpl_propertylist *skyHdr;
        cpl_propertylist *outHdr;
};
*/
struct objSkyStruct {
        int obj;
        int sky;
};

struct exposureEntry {
        cpl_frame   *frame;
        cpl_propertylist *hdr;
        bool        isObject;
        double      dit;
        double      obsDate;
        double      centeredObsDate;
        int         skyIndex;
        double      alt; 
        double      rot; 
        double      derot_corr; 
        hdrl_image  *rawImage;
        cpl_image   *dqiImage;
        hdrl_imagelist *cube;
        cpl_imagelist *cubeBpm;
        cpl_propertylist *cubeHdr;
        cpl_mask    *badPixelMask; //refers to rawImage BPM
        hdrl_image  *darkSubtrImage; //dark subtracted,
                                   // flat fielded, distortion corrected image
        hdrl_image  *skySubtrImage;  //sky subtracted,
                                   // flat fielded, distortion corrected image
};

typedef enum {NODATA, SCIENCE, PSF, STD, STD_FLUX, MODE_PUPIL, IGNORE_SOF_MODE
} sofModes;

struct sofStruct {
        sofModes    mode;
        ifsBand     band;
        ifsPreopticsScale scale;
        ifsInstrument instrument;
        int         exposureTableCnt;  // number of detected exposures
        int         exposureTableSize; // allocated dimension table
        int         objectCnt;         // number of objects
        struct exposureEntry *exposureTable;
//        struct objSkyStruct **objSkyPairs;
        hdrl_image  *masterDark;
        hdrl_image  *masterFlat;
        cpl_image   *waveMap;
        cpl_mask    *badPixelMask; //ORed BPM of all calibration files
        cpl_image   *dqi;
        cpl_polynomial **distortion;
        cpl_vector  *oh_ref_peaks;
        cpl_frame    *oh_ref_frame;
        cpl_table      *borders;
        cpl_polynomial *poly_u;
        cpl_polynomial *poly_v;
        cpl_vector  *distances;
        cpl_bivector *positions;
};
/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/

cpl_error_code eris_ifu_jitter_fill_common_parameterlist(
        const char *recipeName,
        jitterModes jitterMode,
        cpl_parameterlist *pl);

cpl_error_code eris_ifu_stdstar_fill_common_parameterlist(
        const char *recipeName,
        jitterModes jitterMode,
        cpl_parameterlist *pl);

cpl_error_code eris_ifu_jitter_fetch_params(
		const char* context,
		const char* recipe_name,
		const cpl_parameterlist * parlist,
        struct stdParamStruct *stdParams,
        struct paramStruct *params);


cpl_error_code eris_ifu_jitter_processSof(
		cpl_frameset* frames,
		struct stdParamStruct stdParams,
		struct paramStruct params,
		struct sofStruct *sof);

cpl_error_code eris_ifu_jitter_get_instrument_settings(
    cpl_frameset *frames,
    ifsInstrument *instrument,
    ifsBand *band,
    ifsPreopticsScale *scale);

cpl_error_code eris_ifu_jitter_get_objsky_exposures(
        cpl_frameset *frames,
        struct stdParamStruct params,
        struct sofStruct *sof);

cpl_error_code eris_ifu_jitter_get_objsky_pairs(
        struct sofStruct *sof);

void eris_free_exposureEntry(struct exposureEntry* ee);

cpl_error_code eris_ifu_jitter_fill_extract_parameterlist(char* context,
		jitterModes jitterMode,
		cpl_parameterlist *pl);

#endif


