/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$:
 * $Date$:
 * $Rev$:
 */

/* 
 * This file defines structures and methods used to store and maintain
 * an ERIS/NIX 'master_dark' result.
 */

#ifndef ERIS_NIX_MASTER_DARK_H
#define ERIS_NIX_MASTER_DARK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

/*-----------------------------------------------------------------------------
                                   Declarations
 -----------------------------------------------------------------------------*/

typedef struct {
    char             * filename;
    hdrl_image       * dark;
    cpl_mask         * hot_bpm;
    cpl_propertylist * plist;
} master_dark;

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

master_dark * en_master_dark_create(const hdrl_image *,
                                    const cpl_mask *,
                                    const char *,
                                    const cpl_propertylist *);

void en_master_dark_delete(master_dark *);

master_dark * en_master_dark_load_from_frameset(const cpl_frameset *,
                                                const char *,
                                                cpl_frameset *);

master_dark * en_master_dark_test(const cpl_size nx,
                                  const cpl_size ny,
                                  const double dit,
                                  const int ndit,
                                  const char * mode);

#endif /* ERIS_NIX_MASTER_DARK_H */


