/* $Id: eris_utils.h,v 1.15 2013-07-22 13:38:01 jtaylor Exp $
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: jtaylor $
 * $Date: 2013-07-22 13:38:01 $
 * $Revision: 1.15 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ERIS_UTILS_H
#define ERIS_UTILS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

#define CPL_DFS_PRO_DID "PRO-1.16"
/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code eris_setup_product_header(const char* filename,
					    const char* pro_catg,
					    cpl_frame_type type,
					    const char* recipe_name,
					    cpl_frameset* frameset,
					    const cpl_parameterlist* parlist,
					    cpl_propertylist *plist);
const char * eris_get_license(void);
cpl_error_code eris_check_error_code(const char* func_id);
int eris_print_rec_status(const int val);
long
eris_image_get_threshpix(cpl_image* img, double threshold,
		cpl_boolean thresh_is_min);
cpl_error_code
eris_image_flag_threshpix(cpl_image** img, double threshold,
		cpl_boolean thresh_is_min);
cpl_error_code
eris_dfs_extract_raw_frames (cpl_frameset * input, cpl_frameset * raws);
cpl_error_code
eris_dfs_extract_cal_frames (cpl_frameset * input, cpl_frameset * calibs);

cpl_frameset*
eris_dfs_extract_frames_with_tag (cpl_frameset * input, const char* rtag);
cpl_error_code
eris_dfs_check_input_tags(cpl_frameset * input, const char** tags, const int n,
		const int mode);

cpl_error_code
eris_get_sat_qc_for_image(const char* frame_name, cpl_frame* frm_mdark,
		const double saturation, const double saturation_negative,
		const double threshold, const long long i, cpl_propertylist* applist);

cpl_error_code
eris_get_sat_qc_for_cube(const char* frame_name, cpl_frame* frm_mdark,
		const double saturation, const double saturation_negative,
		const double threshold, const long long i, cpl_propertylist* applist);

cpl_error_code
eris_get_sat_pix_qc_for_image(const char* frame_name, cpl_frame* frm_mdark,
		const double saturation, const double saturation_negative,
		const long long i, cpl_propertylist* applist);

cpl_error_code
eris_get_thresh_pix_qc_for_image(const char* frame_name, cpl_frame* frm_mdark,
		const double threshold, const long long i, cpl_propertylist* applist);
cpl_boolean
eris_param_has_changed(const cpl_parameter* p);

cpl_error_code
eris_parameters_get_int(const cpl_parameterlist* parlist,
                    const char* pname, int *pvalue);
cpl_error_code
eris_parameters_get_double(const cpl_parameterlist* parlist,
                    const char* pname, double *pvalue);
cpl_error_code
eris_files_dont_exist(cpl_frameset *frameset);

cpl_error_code
eris_image_flag_nan(cpl_image** ima);
#endif
