from adari_core.data_libs.master_wave_cal import MasterWaveCalReport
from adari_core.plots.text import TextPlot
from .eris_utils import ErisSetupInfo
from .eris_utils import ErisReportMixin

import os


class ErisWavelengthReport(ErisReportMixin, MasterWaveCalReport):
    center_size = 500

    def __init__(self):
        super().__init__("eris_wavelength")

    def parse_sof(self):
        wave = None
        for filename, catg in self.inputs:
            if catg == "WAVE_LAMP_RESAMPLED":
                wave = filename

        file_lists = []
        if wave is not None:
            file_lists.append(
                {
                    "wave": wave,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        vspace = 0.3

        hdu = self.hdus[0]["wave"]
        fname = os.path.basename(str(hdu.filename()))
        instrume = str(hdu[0].header.get("INSTRUME"))
        procatg = str(hdu[0].header.get("HIERARCH ESO PRO CATG"))
        rawname = str(hdu[0].header.get("HIERARCH ESO PRO REC1 RAW1 NAME"))

        n_ext = len(hdu)
        exts = range(1, n_ext)

        for ext in exts:
            panel = super().generate_single_panel(
                hdu=hdu[ext],
                cut_pos=1060,
            )

            # Text Plot
            t1 = TextPlot(columns=1, v_space=vspace)
            col1 = (
                instrume,
                "EXTNAME: " + str(ext),
                "PRO CATG: " + procatg,
                "FILE NAME: " + fname,
                "RAW1 NAME: " + rawname,
            )
            t1.add_data(col1)
            panel.assign_plot(t1, 0, 0, xext=2)

            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            self.metadata = ErisSetupInfo.wavelength(hdu)
            col2 = self.metadata
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

            input_files  = [hdu.filename()]

            panels[panel] = {
                "report_name": "{}_{}_{}".format(instrume, procatg.lower(), str(ext)),
                "report_description": "ERIS wavelength panel - {}".format(fname),
                "report_tags": [],
                "input_files": input_files,
            }

        return panels


rep = ErisWavelengthReport()
