/* $Id: eris_dfs.h,v 1.14 2013-07-22 13:38:01 jtaylor Exp $
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: jtaylor $
 * $Date: 2013-07-22 13:38:01 $
 * $Revision: 1.14 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ERIS_DFS_H
#define ERIS_DFS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>


/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/* Define here the PRO.CATG keywords */
#define ERIS_RECIPE_OUT_PROCATG            "ERIS_RECIPE_DOCATG_RESULT"
#define ERIS_RECIPE_OUT_CALIB_PROCATG      "ERIS_RECIPE_DOCATG_CALIB_RESULT"
#define ERIS_NIX_RECIPE_OUT_PROCATG        "ERIS_NIX_RECIPE_DOCATG_RESULT"
#define ERIS_IFU_RECIPE_OUT_PROCATG        "ERIS_IFU_RECIPE_DOCATG_RESULT"

/* Define here the DO.CATG keywords */
#define ERIS_RECIPE_CALIB_RAW              "ERIS_RECIPE_CALIB_DOCATG_RAW"
#define ERIS_RECIPE_RAW                    "ERIS_RECIPE_DOCATG_RAW"
#define ERIS_NIX_RECIPE_RAW                "ERIS_NIX_RECIPE_DOCATG_RAW"
#define ERIS_IFU_RECIPE_RAW                "ERIS_IFU_RECIPE_DOCATG_RAW"
#define ERIS_CALIB_FLAT         "FLAT"

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/

cpl_error_code eris_dfs_set_groups(cpl_frameset *);

#endif
