/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERIS_IFU_CONSTANTS_H
#define ERIS_IFU_CONSTANTS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
/*----------------------------------------------------------------------------*/
/**
 * @defgroup eris_ifu_functions    IFU Miscellaneous Functions
 */
/*----------------------------------------------------------------------------*/

/**@{*/

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

#define SLITLET_CNT   32
#define SLITLET_WIDTH 64
/*
 *  To model the wall brick like layout of the slitlets the slitlets
 *  are assigned to one of four blocks.
 */
#define SLITLET_BLOCK_CNT 4
#define SLITLET_BLOCK0_CNT 15
#define SLITLET_BLOCK1_CNT 15
#define SLITLET_BLOCK2_CNT 1
#define SLITLET_BLOCK3_CNT 1
static const int slitlet_block[SLITLET_CNT] = { 0,1,0,1, 0,1,0,1,
                                                0,1,0,1, 0,1,0,2,
                                                3,1,0,1, 0,1,0,1,
                                                0,1,0,1, 0,1,0,1};

/* indices how to sort slitlets from top to down */
static const int rowIndices[SLITLET_CNT] = {  8,  7,  9,  6, 10,  5, 11,  4,
                                             12,  3, 13,  2, 14,  1, 15,  0,
                                             31, 16, 30, 17, 29, 18, 28, 19,
                                             27, 20, 26, 21, 25, 22, 24, 23};

/* indices on detector from left to right */
static const int rowIndicesDet[SLITLET_CNT] =  { 0,  1,  2,  3,  4,  5,  6,  7,
                                                 8,  9, 10, 11, 12, 13, 14, 15,
                                                16, 17, 18, 19, 20, 21, 22, 23,
                                                24, 25, 26, 27, 28, 29, 30, 31};

#define AR_LAMP    1
#define KR_LAMP    2
#define NE_LAMP    4
#define XE_LAMP    8
#define QTH_LAMP  16

typedef enum {
	OTHER_INSTRUMENT, SPIFFI, SPIFFIER, NIX, UNSET_INSTRUMENT
} ifsInstrument;

typedef enum {
	UNDEFINED_BAND,
	J_LOW, H_LOW, K_LOW,
	J_SHORT, J_MIDDLE, J_LONG,
	H_SHORT, H_MIDDLE, H_LONG,
	K_SHORT, K_MIDDLE, K_LONG, B_PUPIL,
	J_SPIFFI, H_SPIFFI, K_SPIFFI, HK_SPIFFI
} ifsBand;

typedef enum {
	UNDEFINED_SCALE,
	S250MAS,
	S100MAS,
	S25MAS,
	PUPIL
} ifsPreopticsScale;


#endif
/**@}*/


