/* $Id: eris_ifu_resample.h,v 1.14 2013-07-22 13:38:01 jtaylor Exp $
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERIS_IFU_RESAMPLE_H
#define ERIS_IFU_RESAMPLE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <eris_ifu_jitter_static.h>

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/
/* resampling params default values */

#define PRODCATG_WHITELIGHT "ANCILLARY.IMAGE.WHITELIGHT"
#define PRODCATG_EXPOSUREMAP "ANCILLARY.EXPMAP"
#define RENKA_CRITICAL_RADIUS 1.25 //As in MUSE (see user manual)
#define LANCZOS_KERNEL_SIZE 2 //

#define DRIZZLE_DOWN_SCALING_FACTOR_X 0.8
#define DRIZZLE_DOWN_SCALING_FACTOR_Y 0.8
#define DRIZZLE_DOWN_SCALING_FACTOR_Z 0.8


/* Default field margin (in percent), if the user does not specify any. 5
 * percent is also used in the software package swarp */
#define FIELDMARGIN 5.
#define EDGETRIM 2
#define LOOP_DISTANCE 3
#define OH_POLY_DEG 0
#define EXTNAME_DATA  "DATA"
#define EXTNAME_BPM   "BPM"
#define EXTNAME_ERROR "ERROR"
#define EXTNAME_DATA_COMMENT  "This extension contains data values"
#define EXTNAME_BPM_COMMENT   "This extension contains bad pixel values"
#define EXTNAME_ERROR_COMMENT "This extension contains data errors"

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code
eris_ifu_combine(cubeType obj_type,
                 /*struct stdParamStruct stdParams, struct paramStruct params, */
                 cpl_frameset* frameset,
                 const cpl_parameterlist * parlist, const char* recipe_name,
                 const char* pipefile_prefix);
cpl_error_code
eris_ifu_combine_pbp(cpl_frameset* frameset, 
        const cpl_parameterlist * parlist, 
        const char *proCatg,
        const char *filenameSpec,
        float *offsetx, 
        float *offsety, 
        const char* offunit,
        const char* recipe_name,
        const char* pipefile_prefix);
cpl_error_code
eris_ifu_resample_save_cube(hdrl_resample_result *aCube,
                       const char              *procatg,
                       const char              *recipe,
                       const char              *filename,
                       const cpl_parameterlist *parlist,
                       cpl_frameset            *frameset,
					   cpl_boolean             gen_phase3);
cpl_error_code
eris_ifu_cube_collapse_mean_and_save(const char*, cpl_frameset*,
                                     const cpl_parameterlist*, const char*, /*const char*,*/
									 cpl_boolean apply_flat, cpl_boolean is_pupil);

cpl_error_code eris_ifu_resample_trim_edge(hdrl_image *himg, int edge_trim);
#endif
