/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$
 * $Date$
 * $Rev$
*/

#ifndef ERIS_NIX_DFS_H
#define ERIS_NIX_DFS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/* Define here the PRO.CATG keywords */
#define ERIS_NIX_NL_BPM_PRO_CATG                 "BP_MAP_NL"
#define ERIS_NIX_CAL_DET_OBJECT_LSS_JITTER_PRO_CATG "CAL_DET_OBJECT_LSS_JITTER"
#define ERIS_NIX_CAL_DET_OBJECT_FPC_PRO_CATG     "CAL_DET_OBJECT_FPC" 
#define ERIS_NIX_CAL_DET_OBJECT_APP_PRO_CATG     "CAL_DET_OBJECT_APP"
#define ERIS_NIX_CAL_DET_OBJECT_SAM_PRO_CATG     "CAL_DET_OBJECT_SAM"


#define ERIS_NIX_CAL_DET_STD_FPC_PRO_CATG     "CAL_DET_STD_FPC"
#define ERIS_NIX_CAL_DET_STD_APP_PRO_CATG     "CAL_DET_STD_APP"
#define ERIS_NIX_CAL_DET_STD_SAM_PRO_CATG     "CAL_DET_STD_SAM"

#define ERIS_NIX_RAW_PUPIL_LAMP_OPEN_DO_CATG     "PUPIL_LAMP_OPEN"
#define ERIS_NIX_RAW_PUPIL_LAMP_JHK_DO_CATG      "PUPIL_LAMP_JHK"
#define ERIS_NIX_RAW_PUPIL_LAMP_LM_DO_CATG       "PUPIL_LAMP_LM"
#define ERIS_NIX_RAW_PUPIL_LAMP_CROSS_DO_CATG    "PUPIL_LAMP_CROSS"
#define ERIS_NIX_RAW_PUPIL_LAMP_MASK_DO_CATG     "PUPIL_LAMP_MASK"


#define ERIS_NIX_RAW_PUPIL_SKY_OPEN_DO_CATG     "PUPIL_SKY_OPEN"
#define ERIS_NIX_RAW_PUPIL_SKY_JHK_DO_CATG      "PUPIL_SKY_JHK"
#define ERIS_NIX_RAW_PUPIL_SKY_LM_DO_CATG       "PUPIL_SKY_LM"
#define ERIS_NIX_RAW_PUPIL_SKY_CROSS_DO_CATG    "PUPIL_SKY_CROSS"
#define ERIS_NIX_RAW_PUPIL_SKY_MASK_DO_CATG     "PUPIL_SKY_MASK"
#define ERIS_NIX_RAW_PUPIL_SKY_APP_DO_CATG      "PUPIL_SKY_APP"
#define ERIS_NIX_RAW_PUPIL_SKY_SAM_DO_CATG      "PUPIL_SKY_SAM"
#define ERIS_NIX_RAW_PUPIL_SKY_LYOT_DO_CATG     "PUPIL_SKY_LYOT"
#define ERIS_NIX_RAW_PUPIL_SKY_LYOTND_DO_CATG   "PUPIL_SKY_LYOTND"


#define ERIS_NIX_RAW_PUPIL_DARK_OPEN_DO_CATG     "PUPIL_DARK_OPEN"
#define ERIS_NIX_RAW_PUPIL_DARK_JHK_DO_CATG      "PUPIL_DARK_JHK"
#define ERIS_NIX_RAW_PUPIL_DARK_LM_DO_CATG       "PUPIL_DARK_LM"
#define ERIS_NIX_RAW_PUPIL_DARK_CROSS_DO_CATG    "PUPIL_DARK_CROSS"
#define ERIS_NIX_RAW_PUPIL_DARK_MASK_DO_CATG     "PUPIL_DARK_MASK"


#define ERIS_NIX_RAW_PUPIL_BKG_OPEN_DO_CATG     "PUPIL_BACKGROUND_OPEN"
#define ERIS_NIX_RAW_PUPIL_BKG_JHK_DO_CATG      "PUPIL_BACKGROUND_JHK"
#define ERIS_NIX_RAW_PUPIL_BKG_LM_DO_CATG       "PUPIL_BACKGROUND_LM"
#define ERIS_NIX_RAW_PUPIL_BKG_CROSS_DO_CATG    "PUPIL_BACKGROUND_CROSS"
#define ERIS_NIX_RAW_PUPIL_BKG_MASK_DO_CATG     "PUPIL_BACKGROUND_MASK"

#define ERIS_NIX_RAW_PUPIL_SKY_DO_CATG       "PUPIL_SKY"
#define ERIS_NIX_RAW_PUPIL_LAMP_DO_CATG      "PUPIL_LAMP"
#define ERIS_NIX_RAW_PUPIL_DARK_DO_CATG      "PUPIL_DARK"
#define ERIS_NIX_RAW_PUPIL_BKG_DO_CATG       "PUPIL_BACKGROUND"



#define ERIS_NIX_CAL_DET_OBJECT_JITTER_PRO_CATG  "CAL_DET_OBJECT_JITTER"
#define ERIS_NIX_CAL_DET_SKY_APP_PRO_CATG        "CAL_DET_SKY_APP"
#define ERIS_NIX_CAL_DET_SKY_FPC_PRO_CATG        "CAL_DET_SKY_FPC" 
#define ERIS_NIX_CAL_DET_SKY_JITTER_PRO_CATG     "CAL_DET_SKY_JITTER"

#define ERIS_NIX_CAL_DET_PUPIL_LAMP_PRO_CATG "PUPIL_LAMP"
#define ERIS_NIX_CAL_DET_PUPIL_LAMP_OPEN_PRO_CATG "PUPIL_LAMP_OPEN"
#define ERIS_NIX_CAL_DET_PUPIL_LAMP_MASK_PRO_CATG "PUPIL_LAMP_MASK"

#define ERIS_NIX_CAL_DET_PUPIL_SKY_PRO_CATG  "PUPIL_SKY"
#define ERIS_NIX_CAL_DET_PUPIL_SKY_OPEN_PRO_CATG  "PUPIL_SKY_OPEN"
#define ERIS_NIX_CAL_DET_PUPIL_SKY_MASK_PRO_CATG  "PUPIL_SKY_MASK"

#define ERIS_NIX_CAL_DET_PUPIL_BKG_PRO_CATG  "PUPIL_BACKGROUND"
#define ERIS_NIX_CAL_DET_PUPIL_BKG_OPEN_PRO_CATG  "PUPIL_BACKGROUND_OPEN"
#define ERIS_NIX_CAL_DET_PUPIL_BKG_MASK_PRO_CATG  "PUPIL_BACKGROUND_MASK"


#define ERIS_NIX_CAL_DET_PUPIL_DARK_PRO_CATG  "PUPIL_DARK"
#define ERIS_NIX_CAL_DET_PUPIL_DARK_OPEN_PRO_CATG  "PUPIL_DARK_OPEN"
#define ERIS_NIX_CAL_DET_PUPIL_DARK_MASK_PRO_CATG  "PUPIL_DARK_MASK"

#define ERIS_NIX_CAL_DET_STD_JITTER_PRO_CATG     "CAL_DET_STD_JITTER"
#define ERIS_NIX_CAL_DET_OBJECT_LSS_JITTER_PRO_CATG "CAL_DET_OBJECT_LSS_JITTER"
#define ERIS_NIX_CAL_DET_SKY_LSS_JITTER_PRO_CATG "CAL_DET_SKY_LSS_JITTER"
#define ERIS_NIX_CAL_DET_STD_LSS_JITTER_PRO_CATG "CAL_DET_STD_LSS_JITTER"
#define ERIS_NIX_CAL_PHOT_CATALOGUE_PRO_CATG     "CAL_PHOT_CATALOGUE"
#define ERIS_NIX_CAL_PHOT_MATCH_CATALOGUE_PRO_CATG "CAL_PHOT_MATCHCAT"
#define ERIS_NIX_CAL_PHOT_OBJECT_JITTER_PRO_CATG "CAL_PHOT_OBJECT_JITTER"
#define ERIS_NIX_CAL_PHOT_REF_CATALOGUE_PRO_CATG "CAL_PHOT_REFCAT"
#define ERIS_NIX_CAL_PHOT_STD_JITTER_PRO_CATG    "CAL_PHOT_STD_JITTER"
#define ERIS_NIX_CAL_WCS_CATALOGUE_PRO_CATG      "CAL_WCS_CATALOGUE"
#define ERIS_NIX_CAL_WCS_MATCH_CATALOGUE_PRO_CATG "CAL_WCS_MATCHCAT"
#define ERIS_NIX_CAL_WCS_OBJECT_JITTER_PRO_CATG  "CAL_WCS_OBJECT_JITTER"
#define ERIS_NIX_CAL_WCS_REF_CATALOGUE_PRO_CATG  "CAL_WCS_REFCAT"
#define ERIS_NIX_CAL_WCS_REPORT_PRO_CATG         "CAL_WCS_REPORT"
#define ERIS_NIX_CAL_WCS_STD_JITTER_PRO_CATG     "CAL_WCS_STD_JITTER"
#define ERIS_NIX_CALIB_OBJECT_JITTER_PRO_CATG    "CALIB_OBJECT_JITTER"
#define ERIS_NIX_COEFFS_CUBE_PRO_CATG            "COEFFS_CUBE"
#define ERIS_NIX_CORRECTED_OBJECT_LSS_JITTER_PRO_CATG "CORRECTED_OBJECT_LSS_JITTER"
#define ERIS_NIX_CORRECTED_STD_LSS_JITTER_PRO_CATG "CORRECTED_STD_LSS_JITTER"
#define ERIS_NIX_DET_LIN_INFO_PRO_CATG           "DET_LIN_INFO"
#define ERIS_NIX_GAIN_PRO_CATG                   "GAIN_INFO"
#define ERIS_NIX_IMG_CATALOGUE_PRO_CATG          "IMG_OBS_CATALOGUE"
#define ERIS_NIX_IMG_OBS_COMBINED_PRO_CATG       "IMG_OBS_COMBINED"
#define ERIS_NIX_IMG_STD_COMBINED_PRO_CATG       "IMG_STD_COMBINED"
#define ERIS_NIX_LSS_OBS_COMBINED_PRO_CATG       "LSS_OBS_COMBINED"
#define ERIS_NIX_LSS_STD_COMBINED_PRO_CATG       "LSS_STD_COMBINED"
#define ERIS_NIX_LSS_STARTRACE_SKY               "LSS_STARTRACE_SKY"
#define ERIS_NIX_LSS_TRACE_FIT                   "LSS_TRACE_FIT"
#define ERIS_NIX_MASTER_BPM_LAMP_PRO_CATG        "MASTER_BPM_LAMP"
#define ERIS_NIX_MASTER_BPM_LSS_PRO_CATG         "MASTER_BPM_LSS"
#define ERIS_NIX_MASTER_BPM_SKY_PRO_CATG         "MASTER_BPM_SKY"
#define ERIS_NIX_MASTER_DARK_IMG_PRO_CATG        "MASTER_DARK_IMG"
#define ERIS_NIX_MASTER_DARK_IFU_PRO_CATG        "MASTER_DARK_IFU"
#define ERIS_NIX_MASTER_FLAT_LAMP_HIFREQ_PRO_CATG "MASTER_FLAT_LAMP_HIFREQ"
#define ERIS_NIX_MASTER_FLAT_LAMP_LOFREQ_PRO_CATG "MASTER_FLAT_LAMP_LOFREQ"
#define ERIS_NIX_MASTER_FLAT_LSS_HIFREQ_PRO_CATG "MASTER_FLAT_LSS_HIFREQ"
#define ERIS_NIX_MASTER_FLAT_LSS_LOFREQ_PRO_CATG "MASTER_FLAT_LSS_LOFREQ"
#define ERIS_NIX_MASTER_FLAT_SKY_HIFREQ_PRO_CATG "MASTER_FLAT_SKY_HIFREQ"
#define ERIS_NIX_MASTER_FLAT_SKY_LOFREQ_PRO_CATG "MASTER_FLAT_SKY_LOFREQ"
#define ERIS_NIX_MASTER_FLAT_TWILIGHT_LOFREQ_PRO_CATG \
                                                 "MASTER_FLAT_TWILIGHT_LOFREQ"
#define ERIS_NIX_MASTER_STARTRACE_PRO_CATG       "MASTER_STARTRACE"
#define ERIS_NIX_MASTER_WAVE_PRO_CATG            "MASTER_WAVE"
#define ERIS_NIX_REFERENCE_DARK_PRO_CATG         "MASTER_DARK"
#define ERIS_NIX_PHOT_DATA_PRO_CATG              "PHOT_DATA"
#define ERIS_NIX_REFLEX_PRO_CATG                 "REFLEX"
#define ERIS_NIX_SKYSUB_OBJECT_JITTER_PRO_CATG   "SKYSUB_OBJECT_JITTER"
#define ERIS_NIX_SKYSUB_STD_JITTER_PRO_CATG      "SKYSUB_STD_JITTER"
#define ERIS_NIX_SKYSUB_OBJECT_LSS_JITTER_PRO_CATG "SKYSUB_OBJECT_LSS_JITTER"
#define ERIS_NIX_SKYSUB_STD_LSS_JITTER_PRO_CATG  "SKYSUB_STD_LSS_JITTER"
#define ERIS_NIX_WCS_MATCHED_CATALOGUE_PRO_CATG  "WCS_MATCHED_CATALOGUE"
#define ERIS_NIX_WCS_REFINE_PRO_CATG             "WCS_REFINE"

/* Define here the DO.CATG keywords. IMPORTANT that no definition
   forms a substring of another, or will lead to problems in tag
   matching while loading from frameset */
#define ERIS_NIX_RAW_PERSISTENCE_IMG_DO_CATG     "PERSISTENCE_IMA"
#define ERIS_NIX_RAW_PERSISTENCE_CUBE_DO_CATG    "PERSISTENCE_CUBE"
#define ERIS_NIX_RAW_DARK_DO_CATG                "DARK"
#define ERIS_NIX_RAW_FLAT_LAMP_OFF_DO_CATG       "FLAT_LAMP_OFF"
#define ERIS_NIX_RAW_FLAT_LAMP_ON_DO_CATG        "FLAT_LAMP_ON"
#define ERIS_NIX_RAW_FLAT_SKY_DO_CATG            "FLAT_SKY"
#define ERIS_NIX_RAW_FLAT_SKY_LSS_DO_CATG        "FLAT_SKY_LSS"
#define ERIS_NIX_RAW_FLAT_TWILIGHT_DO_CATG       "FLAT_TWILIGHT"
#define ERIS_NIX_RAW_OBJECT_APP_DO_CATG          "OBJECT_APP"
#define ERIS_NIX_RAW_OBJECT_FPC_DO_CATG          "OBJECT_FPC" 
#define ERIS_NIX_RAW_OBJECT_JITTER_DO_CATG       "OBJECT_JITTER" 
#define ERIS_NIX_RAW_OBJECT_LSS_JITTER_DO_CATG   "OBJECT_LSS_JITTER" 
#define ERIS_NIX_RAW_OBJECT_SAM_DO_CATG          "OBJECT_SAM"

#define ERIS_NIX_RAW_SKY_FPC_DO_CATG             "SKY_FPC" 
#define ERIS_NIX_RAW_SKY_APP_DO_CATG             "SKY_APP"
#define ERIS_NIX_RAW_SKY_JITTER_DO_CATG          "SKY_JITTER" 
#define ERIS_NIX_RAW_SKY_LSS_JITTER_DO_CATG      "SKY_LSS_JITTER" 
#define ERIS_NIX_RAW_STARTRACE_IMG_DO_CATG       "STARTRACE_IMG"
#define ERIS_NIX_RAW_STARTRACE_SPEC_DO_CATG      "STARTRACE_SPEC"
#define ERIS_NIX_RAW_STD_JITTER_DO_CATG          "STD_JITTER"
#define ERIS_NIX_RAW_STD_APP_DO_CATG             "STD_APP"
#define ERIS_NIX_RAW_STD_FPC_DO_CATG             "STD_FPC"
#define ERIS_NIX_RAW_STD_SAM_DO_CATG             "STD_SAM"
#define ERIS_NIX_RAW_STD_LSS_JITTER_DO_CATG      "STD_LSS_JITTER"
#define ERIS_NIX_RAW_WAVE_LAMP_OFF_DO_CATG       "WAVE_LAMP_OFF"
#define ERIS_NIX_RAW_WAVE_LAMP_ON_DO_CATG        "WAVE_LAMP_ON"


/* Define here the MEF extension names */
#define ERIS_NIX_HOT_BPM_EXTENSION               "HOT_BPM"

/* Define here the strings to set in keyword WCS_METHOD */
#define ERIS_NIX_WCS_CATALOGUE_MATCH             "CATALOGUE_MATCH"
#define ERIS_NIX_WCS_JITTER_RELATIVE             "JITTER_RELATIVE"
#define ERIS_NIX_WCS_TEL_POINTING                "TEL_POINTING"

#define CPL_DFS_PRO_DID "PRO-1.16"

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/

#include <hdrl.h>
#include "eris_nix_defs.h"
#include "eris_nix_master_bpm.h"


cpl_error_code eris_nix_dfs_set_groups(cpl_frameset *);

cpl_error_code enu_dfs_save_bpm(const char              * pro_catg,
                                cpl_frameset            * allframes,
                                const cpl_parameterlist * parlist,
                                const cpl_frameset      * usedframes,
                                const master_bpm        * bpm,
                                const char              * recipe,
                                const cpl_propertylist  * pl,
                                const char              * pipe_id,
                                const char              * filename);

cpl_error_code enu_dfs_save_catalogue(cpl_frameset            * frameset,
                                      cpl_frame               * inherit,
                                      const cpl_parameterlist * parlist,
                                      const cpl_table         * catalogue,
                                      const cpl_propertylist  * tablelist,
                                      const char              * cat_name,
                                      const char              * recipe,
                                      const char              * pipe_id,
                                      const char              * preface,
                                      const char              * procat);

cpl_error_code enu_dfs_save_himage(
                                cpl_frameset            * allframes,
                                const cpl_parameterlist * parlist,
                                const cpl_frameset      * provenance,
                                const cpl_boolean         prov_raw,
                                const hdrl_image        * himage,
                                const hdrl_imagelist    * himagelist,
                                const mef_extension_list* mefs,
                                const char              * recipe,
                                const cpl_frame         * inherit,
                                const cpl_propertylist  * applist,
                                const cpl_propertylist  * wcs_plist,
                                const char              * pipe_id,
                                const char              * filename);

cpl_error_code enu_dfs_save_limage(
                                cpl_frameset            * allframes,
                                const cpl_parameterlist * parlist,
                                const cpl_frameset      * provenance,
                                const cpl_boolean       prov_raw,
                                const located_image     * limage,
                                const char              * recipe,
                                const cpl_frame         * inherit,
                                cpl_propertylist        * applist,
                                const char              * pipe_id,
                                const char              * filename);

cpl_error_code enu_dfs_setup_product_header(cpl_propertylist        * header,
                                            const cpl_frame         * product_frame,
                                            const cpl_frameset      * framelist,
                                            const cpl_parameterlist * parlist,
                                            const char              * recipe_id,
                                            const char              * pipeline_id,
                                            const cpl_frame         * inherit,
                                            const cpl_frameset      * provenance,
                                            const cpl_boolean         prov_raw);
 
#endif
