/* $Id$
 *
 * This file is part of the ERIS/NIX Pipeline
 * Copyright (C) 2017 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author$:
 * $Date$:
 * $Rev$:
 */

/* 
 * This file defines structures and methods used to store and maintain
 * an ERIS/NIX 'master_wave' result.
 */

#ifndef ERIS_NIX_MASTER_WAVE_H
#define ERIS_NIX_MASTER_WAVE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

/*-----------------------------------------------------------------------------
                                   Declarations
 -----------------------------------------------------------------------------*/

typedef struct {
    char             * filename;
    hdrl_image       * raw_wave_image;
    cpl_mask         * raw_wave_bpm;
    cpl_image        * raw_wave_confidence;
    hdrl_image       * calibrated_wave_image;
    cpl_mask         * calibrated_wave_bpm;
    cpl_image        * calibrated_wave_confidence;
    cpl_propertylist * plist;
} master_wave;

/*-----------------------------------------------------------------------------
                                       Prototypes
 -----------------------------------------------------------------------------*/

master_wave * en_master_wave_create(const hdrl_image *,
                                    const cpl_mask *,
                                    const cpl_image *,
                                    const hdrl_image *,
                                    const cpl_mask *,
                                    const cpl_image *,
                                    const char *,
                                    const cpl_propertylist *);

void en_master_wave_delete(master_wave *);

master_wave * en_master_wave_load_from_frameset(const cpl_frameset *,
                                                const char *,
                                                cpl_frameset *);

#endif /* ERIS_NIX_MASTER_WAVE_H */


