"""
ERIS Python Package

This package provides a Python PyCPL recipe to support operations 
"""

from importlib.metadata import version, PackageNotFoundError

# Package information
PACKAGE = "eris"
PACKAGE_VERSION = "1.8.15"
PACKAGE_STRING = "ERIS Instrument Pipeline 1.8.15"

# Recipe names
RECIPE_NAME_PUPIL_MONITOR = "eris_nix_pupil_monitor"

# Version string for DFS
PIPE_ID = "eris/1.8.15"

# Try to get version from package metadata, fallback to autotools version
try:
    __version__ = version("pyeris")
except PackageNotFoundError:
    __version__ = PACKAGE_VERSION

__author__ = "Andrea Modigliani"
__email__ = "cpl-help@eso.org"

# No reports module needed

__all__ = [
    "PACKAGE",
    "PACKAGE_VERSION", 
    "PACKAGE_STRING",
    "RECIPE_NAME_PUPIL_MONITOR",
    "PIPE_ID",
    "__version__",
    "__author__",
    "__email__",
]

